/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.jmodel.lang;

import java.util.*;
import jp.gr.java_conf.jaba2.util.ArrayMap;

/**
 * LJInterface
 *
 * @since   Jan. 17, 2000
 * @version Apr. 28, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class LJInterface extends LJClassifier {
    private List parents_ = new ArrayList(); // List<LJInterface>
    // Map<MethodID, LJMethod>
    private Map classVariables_ = new ArrayMap();
    // Map<MethodID, LJMethod>
    private Map instanceMethods_ = new ArrayMap();

    public LJInterface(String name, int access) {
	super(name, access);
    }

    public final void addAttribute(LJAttribute attr) {
	classVariables_.put(attr.getName(), attr);
    }

    public final void addMethod(LJMethod method) {
	instanceMethods_.put(method.getID(), method);
    }

    public final void addParentInterface(LJInterface ljInterface) {
	parents_.add(ljInterface);
    }

    public final LJVariable[] getVariables() {
	Collection values = classVariables_.values();
	LJVariable[] variables = new LJVariable[values.size()];
	return ((LJVariable[])values.toArray(variables));
    }

    public final LJMethod[] getMethods() {
	Collection values = instanceMethods_.values();
	LJMethod[] methods = new LJMethod[values.size()];
	return ((LJMethod[])values.toArray(methods));
    }

    public final LJInterface[] getParentInterfaces() {
	LJInterface[] parents = new LJInterface[parents_.size()];
	return ((LJInterface[])parents_.toArray(parents));
    }
}
