package jp.gr.java_conf.jaba2.text.updater.ruleR;

import org.w3c.dom.*;

/**
 * AbstractRuleFactory is generated by Relaxer based on rule.rlx.
 *
 * @version rule.rlx (Thu Nov 09 13:17:43 JST 2000)
 * @author  Relaxer 0.11.1b (by ASAMI@Yokohama)
 */
public abstract class AbstractRuleFactory implements IRuleFactory {

    /**
     * Creates a <code>RuleSet</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RuleSet
     */
    public RuleSet createRuleSet(Document doc) {
        RuleSet ruleSet_ = createRuleSet();
        ruleSet_.setup(doc);
        return (ruleSet_);
    }

    /**
     * Creates a <code>Rule</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return Rule
     */
    public Rule createRule(Document doc) {
        Rule rule_ = createRule();
        rule_.setup(doc);
        return (rule_);
    }

    /**
     * Creates a <code>Replace</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return Replace
     */
    public Replace createReplace(Document doc) {
        Replace replace_ = createReplace();
        replace_.setup(doc);
        return (replace_);
    }

    /**
     * Creates a <code>RuleSet</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RuleSet
     */
    public RuleSet createRuleSet(Element element) {
        RuleSet ruleSet_ = createRuleSet();
        ruleSet_.setup(element);
        return (ruleSet_);
    }

    /**
     * Creates a <code>Rule</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return Rule
     */
    public Rule createRule(Element element) {
        Rule rule_ = createRule();
        rule_.setup(element);
        return (rule_);
    }

    /**
     * Creates a <code>Replace</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return Replace
     */
    public Replace createReplace(Element element) {
        Replace replace_ = createReplace();
        replace_.setup(element);
        return (replace_);
    }

    /**
     * Creates a <code>RuleSet</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RuleSet
     */
    public RuleSet createRuleSet(RStack stack) {
        RuleSet ruleSet_ = createRuleSet();
        ruleSet_.setup(stack);
        return (ruleSet_);
    }

    /**
     * Creates a <code>Rule</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return Rule
     */
    public Rule createRule(RStack stack) {
        Rule rule_ = createRule();
        rule_.setup(stack);
        return (rule_);
    }

    /**
     * Creates a <code>Replace</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return Replace
     */
    public Replace createReplace(RStack stack) {
        Replace replace_ = createReplace();
        replace_.setup(stack);
        return (replace_);
    }
}
