/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs.config;

import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.SmartElement;

/**
 * ConfigFile
 *
 * @since   Jan. 15, 2000
 * @version Feb.  8, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class ConfigFile implements IConfigItem {
    private String name_;
    private String dir_;
    private String pathname_;
    private String[] suffixes_;
    private boolean isModified_;
    private String link_;

    public ConfigFile(Element element) {
	SmartElement se = new SmartElement(element);
	name_ = se.getAttributeAsNMTOKEN("name");
	dir_ = se.getAttributeAsNMTOKEN("dir");
	pathname_ = se.getAttributeAsNMTOKEN("pathname");
	suffixes_ = se.getAttributeAsNMTOKENS("suffix");
	isModified_ = se.getAttributeAsBoolean("modified");
	link_ = se.getAttributeAsNMTOKEN("link");
    }

    public final String getName() {
	return (name_);
    }

    public final String getDir() {
	return (dir_);
    }

    public final String getPathname() {
	return (pathname_);
    }

    public final String[] getSuffixes() {
	if (suffixes_ == null) {
	    return (null);
	}
	String[] result = new String[suffixes_.length];
	System.arraycopy(suffixes_, 0, result, 0, suffixes_.length);
	return (result);
    }

    public final boolean isModified() {
	return (isModified_);
    }

    public final String getLink() {
	return (link_);
    }
}
