/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs.ftp;

import java.util.*;
import java.io.*;
import java.net.*;
import com.oroinc.net.ftp.*;
import jp.gr.java_conf.jaba2.vfs.*;

/**
 * FTPRoot
 *
 * @since   Jan. 15, 2000
 * @version Jan. 27, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class FTPRoot extends AbstractVFSRoot {
    private FTPClient ftp_;
    private String root_;

    public FTPRoot(FTPClient ftp, String root) {
	ftp_ = ftp;
	root_ = root;
    }

    public void shallowSetup(IFilter filter) throws IOException {
	ftp_.changeWorkingDirectory(root_);
	_shallowSetup(filter);
    }

    public void deepSetup(IFilter filter) throws IOException {
	ftp_.changeWorkingDirectory(root_);
	FTPFile[] files = ftp_.listFiles();
	if (files != null) {
	    _init(files);
	}
	_deepSetup(filter);
    }

    private void _init(FTPFile[] files) throws IOException {
	if (files == null) {
	    throw (new InternalError());
	}
	for (int i = 0;i < files.length;i++) {
	    FTPFile child = files[i];
	    switch (child.getType()) {

	    case FTPFile.DIRECTORY_TYPE:
		addContainer(new FTPContainer(child, this));
		break;
	    case FTPFile.FILE_TYPE:
		addObject(new FTPObject(child, this));
		break;
	    case FTPFile.SYMBOLIC_LINK_TYPE:
		throw (new UnsupportedOperationException());
	    default:
		throw (new InternalError());
	    }
	}
    }

    public FTPFile[] listFiles(String pathname) throws IOException {
	return (ftp_.listFiles(pathname));
    }

    public InputStream openInputStream(FTPObject object) throws IOException {
	return (ftp_.retrieveFileStream(object.getPathname()));
    }
}
