/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax;

import jp.gr.java_conf.jaba2.xml.sax.SimpleEntityResolver;

/**
 * RELAXEntityResolver
 *
 * @since   Nov. 23, 2000
 * @version Sep.  3, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RELAXEntityResolver extends SimpleEntityResolver {
    public RELAXEntityResolver() {
	String coreUri = getClass().getResource(
	    "/jp/gr/java_conf/jaba2/Relaxer/setup/lib/relaxCore.dtd"
	).toExternalForm();
	String nsUri = getClass().getResource(
	    "/jp/gr/java_conf/jaba2/Relaxer/setup/lib/relaxNamespace.dtd"
	).toExternalForm();
	String grammarUri = getClass().getResource(
	    "/jp/gr/java_conf/jaba2/Relaxer/setup/lib/relax.dtd"
	).toExternalForm();
	addSystemId(
	    "http://www.xml.gr.jp/relax/core1/relaxCore.dtd",
	    coreUri
	);
	addSystemId("relaxCore.dtd", coreUri);
	addSystemId("relaxNamespace.dtd", nsUri);
	addSystemId("relax.dtd", grammarUri);
	addPublicId("-//RELAX//DTD RELAX Core 1.0//JA", coreUri);
	addPublicId("-//RELAX//DTD RELAX Namespace 1.0//JA", nsUri); // XXX
	addPublicId("-//RELAX//DTD RELAX Grammar 1.0//JA", grammarUri); // XXX
    }
}
