/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.raw.RContentRule;

/**
 * COccurs
 *
 * @since   Dec. 29, 1999
 * @version Jan. 30, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class COccurs {
    public static final int ONE = 1;
    public static final int ZEROONE = 2;
    public static final int ONEMORE = 3;
    public static final int ZEROMORE = 4;

    private int type_;

    public COccurs(String mark) {
	if (mark == null) {
	    type_ = ONE;
	} else if ("".equals(mark)) {
	    type_ = ONE;
	} else if ("?".equals(mark)) {
	    type_ = ZEROONE;
	} else if ("+".equals(mark)) {
	    type_ = ONEMORE;
	} else if ("*".equals(mark)) {
	    type_ = ZEROMORE;
	} else {
	    throw (new InternalError());
	}
    }

    public final int getType() {
	return (type_);
    }

    public final String getSymbol() {
	switch (type_) {

	case ONE:
	    return ("");
	case ZEROONE:
	    return ("?");
	case ONEMORE:
	    return ("+");
	case ZEROMORE:
	    return ("*");
	default:
	    throw (new InternalError());
	}
    }
}
