/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.util.UArray;
import jp.gr.java_conf.jaba2.datatype.XMLFacet;
import jp.gr.java_conf.jaba2.xml.datatype.*;

/**
 * CRelaxNgElementRule
 *
 * @since   Dec. 24, 1999
 * @version Jul. 30, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class CRelaxNgElementRule extends CSequenceElementRule {
    private String type_;
    private Datatype datatype_;

    public CRelaxNgElementRule(
	String pattern,
	CSequence sequence,
	String type,
	CModule module
    ) {
	this(pattern, sequence, type, null, module);
    }

    public CRelaxNgElementRule(
	String pattern,
	CSequence sequence,
	String type,
	XMLFacet[] facets,
	CModule module
    ) {
	super(pattern, sequence, module);
	type_ = type;
	if (facets != null) {
	    datatype_ = module.makeDatatype(type_, facets);
	} else {
	    datatype_ = module.makeDatatype(type_);
	}
    }

    public final String getType() {
	return (type_);
    }

    public final Datatype getDatatype() {
	return (datatype_);
    }

    public final void setDatatype(Datatype datatype) {
	datatype_ = datatype;
    }
}
