/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.util.UArray;
import jp.gr.java_conf.jaba2.util.ElementCounter;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.xml.UElement;
import jp.gr.java_conf.jaba2.xml.datatype.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;
import jp.gr.java_conf.jaba2.xml.relax.expanded.*;

/**
 * OptimizerController
 *
 * @since   Dec. 14, 2000
 * @version Mar.  5, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class OptimizerController {
    private List threads_ = new ArrayList();
    private boolean needRetry_ = false;
    private OptimizerThreadGroup threadGroup_ = new OptimizerThreadGroup();

    public OptimizerController() {
    }

    public void addThread(ERuleNode rule, EModule module) {
//	OptimizerThread thread
//	    = new OptimizerThread(threadGroup_, rule, module);
	OptimizerThread1 thread
	    = new OptimizerThread1(threadGroup_, rule, module);
	thread.setController(this);
	threads_.add(thread);
    }

    // called from OptimizerThread
    public void needRetry() {
	needRetry_ = true;
    }

    public void optimize() {
	if (threads_.size() == 0) {
	    return;
	}
	_start();
	_prepare();
	_noneResolve();
	_cyclicResolve();
	do {
	    needRetry_ = false;
	    _optimize();
	    _noneResolve();
	    _cyclicResolve();
	} while (needRetry_);
	_naming();
    }

    private void _start() {
	int size = threads_.size();
	for (int i = 0;i < size;i++) {
	    IOptimizerThread thread = (IOptimizerThread)threads_.get(i);
	    thread.start();
	}
    }

    private void _setup() {
	int size = threads_.size();
	for (int i = 0;i < size;i++) {
	    IOptimizerThread thread = (IOptimizerThread)threads_.get(i);
	    thread.setup();
	}
    }

    private void _prepare() {
	_setup();
	int size = threads_.size();
	SyncCounter sync = new SyncCounter(size);
	for (int i = 0;i < size;i++) {
	    IOptimizerThread thread = (IOptimizerThread)threads_.get(i);
	    thread.prepare(sync);
	}
	sync.sync();
    }

    private void _cyclicResolve() {
	_setup();
	int size = threads_.size();
	SyncCounter sync = new SyncCounter(size);
	for (int i = 0;i < size;i++) {
	    IOptimizerThread thread = (IOptimizerThread)threads_.get(i);
	    thread.cyclicResolve(sync);
	}
	sync.sync();
    }

    private void _noneResolve() {
	_setup();
	int size = threads_.size();
	SyncCounter sync = new SyncCounter(size);
	for (int i = 0;i < size;i++) {
	    IOptimizerThread thread = (IOptimizerThread)threads_.get(i);
	    thread.noneResolve(sync);
	}
	sync.sync();
    }

    private void _optimize() {
	_setup();
	int size = threads_.size();
	SyncCounter sync = new SyncCounter(size);
	for (int i = 0;i < size;i++) {
	    IOptimizerThread thread = (IOptimizerThread)threads_.get(i);
	    thread.optimize(sync);
	}
	sync.sync();
    }

    private void _naming() {
	_setup();
	int size = threads_.size();
	SyncCounter sync = new SyncCounter(size);
	for (int i = 0;i < size;i++) {
	    IOptimizerThread thread = (IOptimizerThread)threads_.get(i);
	    thread.naming(sync);
	}
	sync.sync();
    }
}
