package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RNMixed</b> is generated by Relaxer based on relaxNg.rxm.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="mixed">
 *   <tag name="mixed">
 *     <attribute name="datatypeLibrary" type="ngURI"/>
 *   </tag>
 *   <sequence>
 *     <hedgeRef label="elementHedge" occurs="?"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="mixed"&gt;
 *   &lt;tag name="mixed"&gt;
 *     &lt;attribute name="datatypeLibrary" type="ngURI"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;hedgeRef label="elementHedge" occurs="?"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxNg.rxm (Mon Aug 19 21:37:41 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class RNMixed implements java.io.Serializable, IRNSContainer, IRNode, IRNElementHedgeChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://relaxng.org/ns/structure/1.0");
    private String datatypeLibrary_;
    private IRNElementHedgeChoice elementHedge_;
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>RNMixed</code>.
     *
     */
    public RNMixed() {
    }

    /**
     * Creates a <code>RNMixed</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RNMixed(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RNMixed</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RNMixed(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RNMixed</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RNMixed(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RNMixed</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNMixed(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RNMixed</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNMixed(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RNMixed</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNMixed(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RNMixed</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNMixed(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RNMixed</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNMixed(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RNMixed</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNMixed(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RNMixed</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RNMixed</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RNMixed</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        IRelaxNgFactory factory = RelaxNgFactory.getFactory();
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        datatypeLibrary_ = URelaxer.getAttributePropertyAsString(element, "datatypeLibrary");
        if (RNAttribute.isMatch(stack)) {
            setElementHedge(factory.createRNAttribute(stack));
        } else if (RNElement.isMatch(stack)) {
            setElementHedge(factory.createRNElement(stack));
        } else if (RNData.isMatch(stack)) {
            setElementHedge(factory.createRNData(stack));
        } else if (RNValue.isMatch(stack)) {
            setElementHedge(factory.createRNValue(stack));
        } else if (RNList.isMatch(stack)) {
            setElementHedge(factory.createRNList(stack));
        } else if (RNRef.isMatch(stack)) {
            setElementHedge(factory.createRNRef(stack));
        } else if (RNAnyName.isMatch(stack)) {
            setElementHedge(factory.createRNAnyName(stack));
        } else if (RNExternalRef.isMatch(stack)) {
            setElementHedge(factory.createRNExternalRef(stack));
        } else if (RNText.isMatch(stack)) {
            setElementHedge(factory.createRNText(stack));
        } else if (RNEmpty.isMatch(stack)) {
            setElementHedge(factory.createRNEmpty(stack));
        } else if (RNGroup.isMatch(stack)) {
            setElementHedge(factory.createRNGroup(stack));
        } else if (RNChoice.isMatch(stack)) {
            setElementHedge(factory.createRNChoice(stack));
        } else if (RNInterleave.isMatch(stack)) {
            setElementHedge(factory.createRNInterleave(stack));
        } else if (RNMixed.isMatch(stack)) {
            setElementHedge(factory.createRNMixed(stack));
        } else if (RNOptional.isMatch(stack)) {
            setElementHedge(factory.createRNOptional(stack));
        } else if (RNZeroOrMore.isMatch(stack)) {
            setElementHedge(factory.createRNZeroOrMore(stack));
        } else if (RNOneOrMore.isMatch(stack)) {
            setElementHedge(factory.createRNOneOrMore(stack));
        } else if (RNNotAllowed.isMatch(stack)) {
            setElementHedge(factory.createRNNotAllowed(stack));
        } else {
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "mixed");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.datatypeLibrary_ != null) {
            URelaxer.setAttributePropertyByString(element, "datatypeLibrary", this.datatypeLibrary_);
        }
        if (this.elementHedge_ != null) {
            this.elementHedge_.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RNMixed</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RNMixed</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNMixed</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNMixed</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNMixed</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNMixed</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>rNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext getRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>rNSContext</b>.
     *
     * @param rNSContext
     */
    public final void setRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>datatypeLibrary</b>.
     *
     * @return String
     */
    public final String getDatatypeLibrary() {
        return (datatypeLibrary_);
    }

    /**
     * Sets the String property <b>datatypeLibrary</b>.
     *
     * @param datatypeLibrary
     */
    public final void setDatatypeLibrary(String datatypeLibrary) {
        this.datatypeLibrary_ = datatypeLibrary;
    }

    /**
     * Gets the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     * @return IRNElementHedgeChoice
     */
    public final IRNElementHedgeChoice getElementHedge() {
        return (elementHedge_);
    }

    /**
     * Sets the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     * @param elementHedge
     */
    public final void setElementHedge(IRNElementHedgeChoice elementHedge) {
        this.elementHedge_ = elementHedge;
        if (elementHedge != null) {
            elementHedge.setParentRNode(this);
        }
    }

    /**
     * Gets the element to use object construction.
     *
     * @return Element
     */
    public Element getXMLElement() {
        return (xmlElement);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.append("<");
        URelaxer.makeQName(prefix, "mixed", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (datatypeLibrary_ != null) {
            buffer.append(" ");
            buffer.append("datatypeLibrary");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (elementHedge_ != null) {
            elementHedge_.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "mixed", buffer);
        buffer.append(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.print("<");
        URelaxer.makeQName(prefix, "mixed", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (datatypeLibrary_ != null) {
            buffer.print(" ");
            buffer.print("datatypeLibrary");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (elementHedge_ != null) {
            elementHedge_.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "mixed", buffer);
        buffer.print(">");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDatatypeLibraryAsString() {
        return (URelaxer.getString(getDatatypeLibrary()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDatatypeLibraryByString(String string) {
        setDatatypeLibrary(URelaxer.getString(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        if (elementHedge_ != null) {
            classNodes.add(elementHedge_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RNMixed</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://relaxng.org/ns/structure/1.0", "mixed")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (RNAttribute.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNElement.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNData.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNValue.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNList.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNRef.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNAnyName.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNExternalRef.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNText.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNEmpty.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNGroup.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNChoice.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNInterleave.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNMixed.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNOptional.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNZeroOrMore.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNOneOrMore.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNNotAllowed.isMatchHungry(target)) {
            $match$ = true;
        } else {
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNMixed</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNMixed</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
