/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.io.Serializable;
import java.sql.SQLException;
import javax.naming.NamingException;
import org.relaxer.tabular.DataSourceTabular;

/**
 * DataSourceTabularBean
 *
 * @since   Jul. 11, 2001
 * @version Aug. 15, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DataSourceTabularBean implements Serializable {
    private String uri_;
    private String sql_;
    private String username_ = null;
    private String password_ = null;
    private String nsInitial_ = null;
    private String nsRoot_ = null;
    transient private DataSourceTabular tabular_ = null;

    public DataSourceTabularBean() {
    }

    public final void setUri(String uri) {
	uri_ = uri;
	tabular_ = null;
    }

    public final String getUri() {
	return (uri_);
    }

    public final void setSql(String sql) {
	sql_ = sql;
    }

    public final String getSql() {
	return (sql_);
    }

    public final void setUsername(String username) {
	username_ = username;
    }

    public final String getUsername() {
	return (username_);
    }

    public final void setPassword(String password) {
	password_ = password;
    }

    public final String getPassword() {
	return (password_);
    }

    public final void setNamingInitialFactory(String nsInitial) {
	nsInitial_ = nsInitial;
    }

    public final String getNamingInitialFactory() {
	return (nsInitial_);
    }

    public final void setNamingRootUrl(String nsRoot) {
	nsRoot_ = nsRoot;
    }

    public final String getNamingRootUrl() {
	return (nsRoot_);
    }

    public DataSourceTabular getTabular()
	throws SQLException, NamingException {

	if (tabular_ == null) {
	    tabular_ = new DataSourceTabular(uri_, sql_);
	    if (username_ != null && password_ != null) {
		tabular_.setUsername(username_, password_);
	    }
	    if (nsInitial_ != null) {
		tabular_.setNamingInitialFactory(nsInitial_);
	    }
	    if (nsRoot_ != null) {
		tabular_.setNamingRootUrl(nsRoot_);
	    }
	    tabular_.setup();
	}
	return (tabular_);
    }
}
