package org.relaxer.bus.rConfig;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>CComponent</b> is generated by Relaxer based on application.rxm.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="component">
 *   <tag>
 *     <attribute name="name" type="token"/>
 *     <attribute name="class" required="true" type="token"/>
 *   </tag>
 *   <sequence>
 *     <ref label="property" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="component"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="name" type="token"/&gt;
 *     &lt;attribute name="class" required="true" type="token"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="property" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version application.rxm (Wed Jan 02 23:42:46 JST 2002)
 * @author  Relaxer 0.15.1b (http://www.relaxer.org)
 */
public class CComponent implements java.io.Serializable, IRVisitable, IRNode, ICExecutableChoice, ICBusChoice {
    private String name_;
    private String classValue_;
    // List<CProperty>
    private java.util.List property_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>CComponent</code>.
     *
     */
    public CComponent() {
    }

    /**
     * Creates a <code>CComponent</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CComponent(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CComponent</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CComponent(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CComponent</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CComponent(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>CComponent</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CComponent(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>CComponent</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CComponent(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>CComponent</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CComponent(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>CComponent</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CComponent(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>CComponent</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CComponent(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>CComponent</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CComponent(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>CComponent</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CComponent</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CComponent</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        classValue_ = URelaxer.getAttributePropertyAsString(element, "class");
        property_.clear();
        while (!stack.isEmptyElement()) {
            if (CProperty.isMatch(stack)) {
                addProperty(new CProperty(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("component");
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        URelaxer.setAttributePropertyByString(element, "class", this.classValue_);
        size = this.property_.size();
        for (int i = 0;i < size;i++) {
            CProperty value = (CProperty)this.property_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>CComponent</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>CComponent</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CComponent</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CComponent</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CComponent</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CComponent</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>classValue</b>.
     *
     * @return String
     */
    public final String getClassValue() {
        return (classValue_);
    }

    /**
     * Sets the String property <b>classValue</b>.
     *
     * @param classValue
     */
    public final void setClassValue(String classValue) {
        this.classValue_ = classValue;
    }

    /**
     * Gets the CProperty property <b>property</b>.
     *
     * @return CProperty[]
     */
    public final CProperty[] getProperty() {
        CProperty[] array = new CProperty[property_.size()];
        return ((CProperty[])property_.toArray(array));
    }

    /**
     * Sets the CProperty property <b>property</b>.
     *
     * @param property
     */
    public final void setProperty(CProperty[] property) {
        this.property_.clear();
        this.property_.addAll(java.util.Arrays.asList(property));
        for (int i = 0;i < property.length;i++) {
            property[i].setParentRNode(this);
        }
    }

    /**
     * Sets the CProperty property <b>property</b>.
     *
     * @param property
     */
    public final void setProperty(CProperty property) {
        this.property_.clear();
        this.property_.add(property);
        if (property != null) {
            property.setParentRNode(this);
        }
    }

    /**
     * Adds the CProperty property <b>property</b>.
     *
     * @param property
     */
    public final void addProperty(CProperty property) {
        this.property_.add(property);
        if (property != null) {
            property.setParentRNode(this);
        }
    }

    /**
     * Gets number of the CProperty property <b>property</b>.
     *
     * @return int
     */
    public final int getPropertyCount() {
        return (property_.size());
    }

    /**
     * Gets the CProperty property <b>property</b> by index.
     *
     * @param index
     * @return CProperty
     */
    public final CProperty getProperty(int index) {
        return ((CProperty)property_.get(index));
    }

    /**
     * Sets the CProperty property <b>property</b> by index.
     *
     * @param index
     * @param property
     */
    public final void setProperty(int index, CProperty property) {
        this.property_.set(index, property);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<component");
        if (name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(getName()));
            buffer.append("\"");
        }
        buffer.append(" class=\"");
        buffer.append(URelaxer.escapeAttrQuot(getClassValue()));
        buffer.append("\"");
        buffer.append(">");
        size = this.property_.size();
        for (int i = 0;i < size;i++) {
            CProperty value = (CProperty)this.property_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</component>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<component");
        if (name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(getName()));
            buffer.print("\"");
        }
        buffer.print(" class=\"");
        buffer.print(URelaxer.escapeAttrQuot(getClassValue()));
        buffer.print("\"");
        buffer.print(">");
        size = this.property_.size();
        for (int i = 0;i < size;i++) {
            CProperty value = (CProperty)this.property_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</component>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getClassValueAsString() {
        return (URelaxer.getString(getClassValue()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setClassValueByString(String string) {
        setClassValue(string);
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(property_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CComponent</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "component")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!CProperty.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CComponent</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CComponent</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
