/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.bus.sample;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.relaxer.bus.*;
import org.relaxer.bus.model.*;

/**
 * SampleComponent
 *
 * @since   Jan.  1, 2002
 * @version Jan.  3, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class SampleComponent extends AbstractRBusComponent {
    public void setup(IRBusProperties properties) {
    }

    public IRBusSignal stimulas(IRBusSignal signal) {
	try {
	    PlainSignal newSignal = new PlainSignal();
	    IRBusValue[] values = signal.getValues();
	    for (int i = 0;i < values.length;i++) {
		IRBusValue value = values[i];
		newSignal.addValue(
		    new InputStreamValue(
			value.getUri() + ".xml",
			value.getInputStream()
		    )
		);
	    }
	    return (newSignal);
	} catch (IOException e) {
	    throw (new RBusException(e));
	}
    }

    public static void main(String[] args)
	throws IOException, SAXException, ParserConfigurationException {

	RBus.main("/org/relaxer/bus/sample/sample.xml", args);
    }
}
