/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.dialog;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.relaxer.tabular.ITabular;

/**
 * IDialogSlot
 *
 * @since   Jun. 30, 2001
 * @version Aug. 14, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public interface IDialogSlot {
    String getName();
    Document getDocument() throws ParserConfigurationException;
    Document[] getDocuments() throws ParserConfigurationException;
    Object getRObject();
    Object[] getRObjects();
    ITabular getTabular();
    void setDocument(Document doc);
    void setDocument(Document doc, Class type);
    void setDocuments(Document[] doc);
    void setDocuments(Document[] doc, Class type);
    void setRObject(Object value);
    void setRObjects(Object[] value);
    void setTabular(ITabular tabuler);
    Class getType();
    void load() throws IOException;
    void save() throws IOException;
    void setDialogSpace(IDialogSpace space);
    String resolve(String uri);
}
