/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.goldenport.ports.interpreter;

import org.w3c.dom.*;
import org.relaxer.goldenport.*;

/**
 * ExprPattern
 *
 * @since   Jul.  6, 2002
 * @version Jul.  8, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class ExprPattern extends AbstractPattern {
    private Element define_;

    public ExprPattern(Element define) {
	define_ = define;
    }

    public int startElement(
	Element element,
	PortContext context,
	PortNodeList result
    ) {
	context.pushElement(element);
	result.addChildren(define_);
	return (IPortConstants.EVAL_CHILDREN);
    }

    public void endElement(
	Element element,
	PortNodeList children,
	PortContext context,
	PortNodeList result
    ) {
	result.setup(children);
	context.popElement();
    }
}
