/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.util.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.sql.SQLException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;
import org.relaxer.dialog.DefaultDialogSpace;
import org.relaxer.beans.DialogSpaceBean;
import org.relaxer.tabular.ITabular;
import org.relaxer.tabular.ITabularAccepter;
import org.relaxer.xml.UDOM;
import org.relaxer.util.URelaxer;
import org.relaxer.util.RObjectSlot;
import org.relaxer.monitor.ULog;

/**
 * AbstractRelaxerTag
 *
 * @since   Feb. 27, 2001
 * @version Jul. 23, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public abstract class AbstractRelaxerTag
    extends BodyTagSupport
    implements IRObjectAccepter, IDocumentAccepter, ITabularAccepter {

    private boolean isBody_ = false;
    private boolean isBodyBefore_ = true;
//    private Object rObject_;
//    private Document doc_;
//    private Class type_;
    private RObjectSlot dataValue_ = new RObjectSlot();
    // name/[scope] or dialog/slot/[scope]
    private String name_;
    private String dialog_;
    private String dialogSlot_;
    private String scope_ = "session";
    private String nameIn_;
    private String dialogIn_;
    private String dialogSlotIn_;
    private String scopeIn_;
    private String nameOut_;
    private String dialogOut_;
    private String dialogSlotOut_;
    private String scopeOut_;
    private List parameterValues_ = new ArrayList(); // List<RObjectSlot>

    protected AbstractRelaxerTag() {
    }

    protected AbstractRelaxerTag(boolean isBody) {
	isBody_ = isBody;
    }

    // IDocumentAccepter
    public void acceptDocument(Document doc) throws JspTagException {
	_log(".acceptDocument(" + doc + ")");
	parameterValues_.add(new RObjectSlot(doc));
    }

    // IDocumentAccepter
    public void acceptDocuments(Document[] docs) throws JspTagException {
	_log(".acceptDocuments(" + docs + ")");
	parameterValues_.add(new RObjectSlot(docs));
    }

    // IDocumentAccepter
    public void acceptDocument(Document doc, Class type)
	throws JspTagException {

	_log(".acceptDocument(" + doc + ", " + type + ")");
	parameterValues_.add(new RObjectSlot(doc, type));
    }

    // IDocumentAccepter
    public void acceptDocuments(Document[] docs, Class type)
	throws JspTagException {

	_log(".acceptDocuments(" + docs + ", " + type + ")");
	parameterValues_.add(new RObjectSlot(docs, type));
    }

    // IRObjectAccepter
    public void acceptRObject(Object rObject) throws JspTagException {
	_log(".acceptRObject(" + rObject + ")");
	parameterValues_.add(new RObjectSlot(rObject));
    }

    // IRObjectAccepter
    public void acceptRObjects(Object[] rObjects) throws JspTagException {
	_log(".acceptRObjects(" + rObjects + ")");
	parameterValues_.add(new RObjectSlot(rObjects));
    }

    // ITabularAccepter
    public void acceptTabular(ITabular tabular) throws JspTagException {
	_log(".acceptTabular(" + tabular + ")");
	parameterValues_.add(new RObjectSlot(tabular));
    }

    public final void setDocument(Document doc) throws JspTagException {
	_log(".setDocument(" + doc + ") [name = " + name_ + "]");
	dataValue_.setDocument(doc);
	_setupAttribute(doc);
	_deliverDocument(doc);
    }

    public final void setDocument(Document doc, Class type)
	throws JspTagException {

	_log(".setDocument(" + doc + ", " + type + ") [name = " + name_ + "]");
	dataValue_.setDocument(doc);
	dataValue_.setType(type);
	_setupAttribute(doc, type);
	_deliverDocument(doc, type);
    }

    public final void setDocuments(Document[] docs) throws JspTagException {
	_log(".setDocuments(" + docs + ") [name = " + name_ + "]");
	dataValue_.setDocuments(docs);
	_setupAttribute(docs);
	_deliverDocuments(docs);
    }

    public final void setDocuments(Document[] docs, Class type)
	throws JspTagException {

	_log(".setDocuments(" + docs + ", " + type + ") [name = " + name_ + "]");
	dataValue_.setDocuments(docs);
	dataValue_.setType(type);
	_setupAttribute(docs, type);
	_deliverDocuments(docs, type);
    }

    public final void setRObject(Object rObject) throws JspTagException {
	_log(".setRObject(" + rObject + ") [name = " + name_ + "]");
	dataValue_.setRObject(rObject);
	_setupAttribute(rObject);
	_deliverRObject(rObject);
    }

    public final void setRObjects(Object[] rObjects) throws JspTagException {
	_log(".setRObjects(" + rObjects + ") [name = " + name_ + "]");
	dataValue_.setRObjects(rObjects);
	_setupAttribute(rObjects);
	_deliverRObjects(rObjects);
    }

    public final void setTabular(ITabular tabular) throws JspTagException {
	_log(".setTabular(" + tabular + ") [name = " + name_ + "]");
	dataValue_.setTabular(tabular);
	_setupAttribute(tabular);
	_deliverTabular(tabular);
    }

    public final Document getDocument() throws ParserConfigurationException {
	return (dataValue_.getDocument());
    }

    public final Object getRObject() throws JspTagException {
	return (dataValue_.getRObject());
    }

    public final ITabular getTabular() throws JspTagException {
	return (dataValue_.getTabular());
    }

    public final Document findDocument() throws JspTagException {
	_log(".findDocument()");
	try {
	    Document doc = dataValue_.getDocument();
	    if (doc != null) {
		_log(".findDocument()->" + doc);
		return (doc);
	    }
	    if (_getNameIn() != null) {
		Object rObject = pageContext.findAttribute(_getNameIn());
		if (rObject != null) {
		    doc = URelaxer.makeRelaxerDocument(rObject);
		    _log(".findDocument()->" + doc);
		    return (doc);
		} else {
		    _log(".findDocument()->null");
		    return (null);
		}
	    } else if (_getDialogSlotIn() != null) {
		DialogSpaceBean dialog = _getDialogSpaceIn();
		doc = dialog.getSlotDocument(_getDialogSlotIn());
		_log(".findDocument()->" + doc);
		return (doc);
	    }
	    _log(".findDocument()->null");
	    return (null);
	} catch (ParserConfigurationException e) {
	    throw (new JspTagException("Parser configuration"));
	}
    }

    public final Document[] findDocuments() throws JspTagException {
	try {
	    Document[] docs = dataValue_.getDocuments();
	    if (docs != null) {
		return (docs);
	    }
	    if (_getNameIn() != null) {
		Object rObject = pageContext.findAttribute(_getNameIn());
		if (rObject != null) {
		    if (rObject instanceof Object[]) {
			Object[] objects = (Object[])rObject;
			docs = new Document[objects.length];
			for (int i = 0;i < docs.length;i++) {
			    docs[i]
				= URelaxer.makeRelaxerDocument(objects[i]);
			}
			return (docs);
		    } else {
			return (
			    new Document[] {
				URelaxer.makeRelaxerDocument(rObject)
			    }
			);
		    }
		} else {
		    return (null);
		}
	    } else if (_getDialogSlotIn() != null) {
		DialogSpaceBean dialog = _getDialogSpaceIn();
		return (dialog.getSlotDocuments(_getDialogSlotIn()));
	    }
	    return (null);
	} catch (ParserConfigurationException e) {
	    throw (new JspTagException("Parser configuration"));
	}
    }

    public final Object findRObject() throws JspTagException {
	_log(".findRObject()");
	Object rObject = dataValue_.getRObject();
	if (rObject != null) {
	    _log(".findRObject()-->" + rObject);
	    return (rObject);
	}
	if (_getNameIn() != null) {
	    rObject = pageContext.findAttribute(_getNameIn());
	    _log(".findRObject()-->" + rObject);
	    return (rObject);
	} else if (_getDialogSlotIn() != null) {
	    DialogSpaceBean dialog = _getDialogSpaceIn();
	    rObject = dialog.getSlotRObject(_getDialogSlotIn());
	    _log(".findRObject()-->" + rObject);
	    return (rObject);
	}
	return (null);
    }

    public final Object[] findRObjects() throws JspTagException {
	Object[] rObjects = dataValue_.getRObjects();
//System.out.println("find:" + this + ":" + rObjects);
	if (rObjects != null) {
	    return (rObjects);
	}
//ULog.log(getClass() + ":name = " + name_);
	if (_getNameIn() != null) {
	    Object value = pageContext.findAttribute(_getNameIn());
	    if (value instanceof Object[]) {
		return ((Object[])value);
	    } else {
		return (new Object[] { value });
	    }
	} else if (_getDialogSlotIn() != null) {
	    DialogSpaceBean dialog = _getDialogSpaceIn();
	    return (dialog.getSlotRObjects(_getDialogSlotIn()));
	}
	return (null);
    }

    public final void setRObjectClassName(String className) {
	try {
	    dataValue_.setType(Class.forName(className));
	} catch (ClassNotFoundException e) {
	    throw (_makeIllegalArgumentException(e));
	} 
    }

    public final void setName(String name) {
	name_ = name;
    }

    public final String getName() {
	return (name_);
    }

    public final void setDialog(String dialog) {
	dialog_ = dialog;
    }

    public final String getDialog() {
	return (dialog_);
    }

    public final void setSlot(String slot) {
	dialogSlot_ = slot;
    }

    public final String getSlot() {
	return (dialogSlot_);
    }

    public final void setScope(String scope) {
	scope_ = scope;
    }

    public final String getScope() {
	return (scope_);
    }

    public final void setNameIn(String name) {
	nameIn_ = name;
    }

    public final String getNameIn() {
	return (nameIn_);
    }

    public final void setDialogIn(String dialog) {
	dialogIn_ = dialog;
    }

    public final String getDialogIn() {
	return (dialogIn_);
    }

    public final void setSlotIn(String slot) {
	dialogSlotIn_ = slot;
    }

    public final String getSlotIn() {
	return (dialogSlotIn_);
    }

    public final void setScopeIn(String scope) {
	scopeIn_ = scope;
    }

    public final String getScopeIn() {
	return (scopeIn_);
    }

    public final void setNameOut(String name) {
	nameOut_ = name;
    }

    public final String getNameOut() {
	return (nameOut_);
    }

    public final void setDialogOut(String dialog) {
	dialogOut_ = dialog;
    }

    public final String getDialogOut() {
	return (dialogOut_);
    }

    public final void setSlotOut(String slot) {
	dialogSlotOut_ = slot;
    }

    public final String getSlotOut() {
	return (dialogSlotOut_);
    }

    public final void setScopeOut(String scope) {
	scopeOut_ = scope;
    }

    public final String getScopeOut() {
	return (scopeOut_);
    }

    private String _getNameIn() {
	if (nameIn_ != null) {
	    return (nameIn_);
	} else {
	    return (name_);
	}
    }

    private String _getDialogIn() {
	if (dialogIn_ != null) {
	    return (dialogIn_);
	} else {
	    return (dialog_);
	}
    }

    private String _getDialogSlotIn() {
	if (dialogSlotIn_ != null) {
	    return (dialogSlotIn_);
	} else {
	    return (dialogSlot_);
	}
    }

    private String _getScopeIn() {
	if (scopeIn_ != null) {
	    return (scopeIn_);
	} else {
	    return (scope_);
	}
    }

    private String _getNameOut() {
	if (nameOut_ != null) {
	    return (nameOut_);
	} else {
	    return (name_);
	}
    }

    private String _getDialogOut() {
	if (dialogOut_ != null) {
	    return (dialogOut_);
	} else {
	    return (dialog_);
	}
    }

    private String _getDialogSlotOut() {
	if (dialogSlotOut_ != null) {
	    return (dialogSlotOut_);
	} else {
	    return (dialogSlot_);
	}
    }

    private String _getScopeOut() {
	if (scopeOut_ != null) {
	    return (scopeOut_);
	} else {
	    return (scope_);
	}
    }

    private String _getDialogInOut() { // XXX
	if (dialogIn_ != null) {
	    return (dialogIn_);
	} else if (dialogOut_ != null) {
	    return (dialogOut_);
	} else {
	    return (dialog_);
	}
    }

    protected void _deliverDocument(Document doc) throws JspTagException {
	IDocumentAccepter parent =
	    (IDocumentAccepter)findAncestorWithClass(
		this,
		IDocumentAccepter.class
	    );
	if (parent != null) {
	    parent.acceptDocument(doc);
	}
    }

    protected void _deliverDocument(
	Document doc,
	Class type
    ) throws JspTagException {
	IDocumentAccepter parent =
	    (IDocumentAccepter)findAncestorWithClass(
		this,
		IDocumentAccepter.class
	    );
	if (parent != null) {
	    parent.acceptDocument(doc, type);
	}
    }

    protected void _deliverDocuments(Document[] docs) throws JspTagException {
	IDocumentAccepter parent =
	    (IDocumentAccepter)findAncestorWithClass(
		this,
		IDocumentAccepter.class
	    );
	if (parent != null) {
	    parent.acceptDocuments(docs);
	}
    }

    protected void _deliverDocuments(
	Document[] docs,
	Class type
    ) throws JspTagException {
	IDocumentAccepter parent =
	    (IDocumentAccepter)findAncestorWithClass(
		this,
		IDocumentAccepter.class
	    );
	if (parent != null) {
	    parent.acceptDocuments(docs, type);
	}
    }

    protected void _deliverRObject(Object object) throws JspTagException {
	IRObjectAccepter parent =
	    (IRObjectAccepter)findAncestorWithClass(
		this,
		IRObjectAccepter.class
	    );
	if (parent != null) {
	    parent.acceptRObject(object);
	}
    }

    protected void _deliverRObjects(Object[] objects) throws JspTagException {
//System.out.println("deliver:" + this + ":" + objects);
	IRObjectAccepter parent =
	    (IRObjectAccepter)findAncestorWithClass(
		this,
		IRObjectAccepter.class
	    );
	if (parent != null) {
	    parent.acceptRObjects(objects);
	}
    }

    protected void _deliverTabular(ITabular tabular) throws JspTagException {
	ITabularAccepter parent =
	    (ITabularAccepter)findAncestorWithClass(
		this,
		ITabularAccepter.class
	    );
	if (parent != null) {
	    parent.acceptTabular(tabular);
	}
    }	

    public void _setupAttribute(Document doc) throws JspTagException {
	if (_getNameOut() != null) {
	    _setupJSPAttribute(doc);
	}
	if (_getDialogSlotOut() != null) {
	    _setupDialogAttribute(doc);
	}
    }

    private void _setupDialogAttribute(Document doc) throws JspTagException {
	if (_getDialogSlotOut() == null) {
	    throw (new JspTagException("no dialog and slot"));
	}
	DialogSpaceBean dialog = _getDialogSpaceOut();
	dialog.setSlotDocument(_getDialogSlotOut(), doc);
    }

    public void _setupAttribute(
	Document doc,
	Class type
    ) throws JspTagException {
	if (_getNameOut() != null) {
	    _setupJSPAttribute(doc, type);
	}
	if (_getDialogSlotOut() != null) {
	    _setupDialogAttribute(doc, type);
	}
    }

    private void _setupJSPAttribute(
	Document doc,
	Class type
    ) throws JspTagException {
	if (_getNameOut() == null) {
	    throw (new JspTagException("no name"));
	}
	_setJSPAttribute(_getNameOut(), doc); // XXX
    }

    private void _setupDialogAttribute(
	Document doc,
	Class type
    ) throws JspTagException {
	if (_getDialogSlotOut() == null) {
	    throw (new JspTagException("no dialog and slot"));
	}
	DialogSpaceBean dialog = _getDialogSpaceOut();
	dialog.setSlotDocument(_getDialogSlotOut(), doc, type);
    }

    public void _setupAttribute(Document[] docs) throws JspTagException {
	if (_getNameOut() != null) {
	    _setupJSPAttribute(docs);
	}
	if (_getDialogSlotOut() != null) {
	    _setupDialogAttribute(docs);
	}
    }

    private void _setupJSPAttribute(Document[] docs) throws JspTagException {
	if (_getNameOut() == null) {
	    throw (new JspTagException("no name"));
	}
	Object[] objects = new Object[docs.length];
	for (int i = 0;i < docs.length;i++) {
	    objects[i] = docs[i];
	}
	_setJSPAttribute(_getNameOut(), objects);
    }

    private void _setupDialogAttribute(
	Document[] docs
    ) throws JspTagException {
	if (_getDialogSlotOut() == null) {
	    throw (new JspTagException("no dialog and slot"));
	}
	DialogSpaceBean dialog = _getDialogSpaceOut();
	dialog.setSlotRObject(_getDialogSlotOut(), docs);
    }

    public void _setupAttribute(
	Document[] docs,
	Class type
    ) throws JspTagException {
	if (_getNameOut() != null) {
	    _setupJSPAttribute(docs, type);
	}
	if (_getDialogSlotOut() != null) {
	    _setupDialogAttribute(docs, type);
	}
    }

    private void _setupJSPAttribute(
	Document[] docs,
	Class type
    ) throws JspTagException {
	if (_getNameOut() == null) {
	    throw (new JspTagException("no name"));
	}
	Object[] objects = new Object[docs.length];
	for (int i = 0;i < docs.length;i++) {
	    objects[i] = URelaxer.makeRelaxerObject(type, docs[i]);
	}
	_setJSPAttribute(_getNameOut(), objects);
    }

    private void _setupDialogAttribute(
	Document[] docs,
	Class type
    ) throws JspTagException {
	if (_getDialogSlotOut() == null) {
	    throw (new JspTagException("no dialog and slot"));
	}
	DialogSpaceBean dialog = _getDialogSpaceOut();
	dialog.setSlotDocuments(_getDialogSlotOut(), docs, type);
    }

    private void _setupAttribute(Object object) throws JspTagException {
	if (_getNameOut() != null) {
	    _setupJSPAttribute(object);
	}
	if (_getDialogSlotOut() != null) {
	    _setupDialogAttribute(object);
	}
    }

    private void _setupJSPAttribute(Object object) throws JspTagException {
	if (_getNameOut() == null) {
	    throw (new JspTagException("no name"));
	}
	_setJSPAttribute(_getNameOut(), object);
    }

    private void _setupDialogAttribute(Object object) throws JspTagException {
	if (_getDialogSlotOut() == null) {
	    throw (new JspTagException("no dialog and slot"));
	}
	DialogSpaceBean dialog = _getDialogSpaceOut();
	dialog.setSlotRObject(_getDialogSlotOut(), object);
    }

    private void _setupAttribute(Object[] objects) throws JspTagException {
	if (_getNameOut() != null) {
	    _setupJSPAttribute(objects);
	}
	if (_getDialogSlotOut() != null) {
	    _setupDialogAttribute(objects);
	}
    }

    private void _setupJSPAttribute(Object[] objects) throws JspTagException {
	if (_getNameOut() == null) {
	    throw (new JspTagException("no name"));
	}
	_setJSPAttribute(_getNameOut(), objects);
    }

    private void _setupDialogAttribute(
	Object[] objects
    ) throws JspTagException {
	if (_getDialogSlotOut() == null) {
	    throw (new JspTagException("no dialog and slot"));
	}
	DialogSpaceBean dialog = _getDialogSpaceOut();
	dialog.setSlotRObjects(_getDialogSlotOut(), objects);
    }

    private void _setupAttribute(ITabular tabular) throws JspTagException {
	if (_getNameOut() != null) {
	    _setupJSPAttribute(tabular);
	}
	if (_getDialogSlotOut() != null) {
	    _setupDialogAttribute(tabular);
	}
    }

    private void _setupJSPAttribute(ITabular tabular) throws JspTagException {
	if (_getNameOut() == null) {
	    throw (new JspTagException("no name"));
	}
	_setJSPAttribute(_getNameOut(), tabular);
    }

    private void _setupDialogAttribute(ITabular tabular)
	throws JspTagException {

	if (_getDialogSlotOut() != null) {
	    throw (new JspTagException("no dialog and slot"));
	}
	DialogSpaceBean dialog = _getDialogSpaceOut();
	dialog.setSlotTabular(_getDialogSlotOut(), tabular);
    }

    protected final DialogSpaceBean _getDialogSpace()
	throws JspTagException {

	return (_getDialogSpace(_getDialogInOut()));
    }

    protected final DialogSpaceBean _getDialogSpaceIn()
	throws JspTagException {

	return (_getDialogSpace(_getDialogIn()));
    }

    protected final DialogSpaceBean _getDialogSpaceOut()
	throws JspTagException {

	return (_getDialogSpace(_getDialogOut()));
    }

    private DialogSpaceBean _getDialogSpace(String dialogName)
	throws JspTagException {

	if (dialogName == null) {
	    Object dialog = _getJSPAttribute("$defaultDialog$");
	    if (dialog == null) {
		dialog = new DialogSpaceBean(new DefaultDialogSpace());
		_setJSPAttribute("$defaultDialog$", dialog);
	    }
	    return ((DialogSpaceBean)dialog); // XXX
	} else {
	    Object dialog = _getJSPAttribute(dialogName);
	    if (dialog == null) {
		throw (new JspTagException(
		    dialogName + " has not been opened"));
	    }
	    if (!(dialog instanceof DialogSpaceBean)) {
		throw (new JspTagException(
		    dialogName + " is not a Dialog"));
	    }
	    return ((DialogSpaceBean)dialog);
	}
    }

    protected final Object _getJSPAttribute(
	String name
    ) throws JspTagException {
//ULog.log(getClass() + "setupJSPAttribute:name = " + name);
	if ("page".equals(scope_)) {
//ULog.log(this + ":doEndTag(page);" + name + "," + object);
	    return (pageContext.getAttribute(name));
	} else if ("application".equals(scope_)) {
	    return (
		pageContext.getAttribute(name, PageContext.APPLICATION_SCOPE)
	    );
	} else if ("session".equals(scope_)) {
	    return (
		pageContext.getAttribute(name, PageContext.SESSION_SCOPE)
	    );
	} else if ("request".equals(scope_)) {
	    return (
		pageContext.getAttribute(name, PageContext.REQUEST_SCOPE)
	    );
	} else {
	    throw (new JspTagException("bad scope = " + scope_));
	}
    }

    protected final void _setJSPAttribute(
	String name,
	Object object
    ) throws JspTagException {
//ULog.log(getClass() + "setupJSPAttribute:name = " + name);
	if ("page".equals(scope_)) {
//ULog.log(this + ":doEndTag(page);" + name + "," + object);
	    pageContext.setAttribute(name, object);
	} else if ("application".equals(scope_)) {
	    pageContext.setAttribute(
		name,
		object,
		PageContext.APPLICATION_SCOPE
	    );
	} else if ("session".equals(scope_)) {
	    pageContext.setAttribute(
		name,
		object,
		PageContext.SESSION_SCOPE
	    );
	} else if ("request".equals(scope_)) {
	    pageContext.setAttribute(
		name,
		object,
		PageContext.REQUEST_SCOPE
	    );
	} else {
	    throw (new JspTagException("bad scope = " + scope_));
	}
    }

    public int doStartTag() throws JspTagException, JspException {
	return (_doRelaxerStartTag());
    }

    public int doEndTag() throws JspTagException, JspException {
	_evaluate();
	return (_doRelaxerEndTag());
    }

    protected int _doRelaxerStartTag() throws JspTagException, JspException {
	if (isBody_) {
	    return (EVAL_BODY_BUFFERED);
	} else {
	    return (EVAL_BODY_INCLUDE);
	}
    }

    protected int _doRelaxerEndTag() throws JspTagException, JspException {
	return (EVAL_PAGE);
    }

    protected final void _evaluate() throws JspTagException {
	RObjectSlot[] params = _makeParams();
	Object object = _doEvaluate(params);
//System.out.println("_evaluate:" + this + ":" + object);
	if (object == null) {
	    return;
	} else if (object instanceof Document) {
	    setDocument((Document)object);
	} else if (object instanceof Document[]) {
	    setDocuments((Document[])object);
	} else if (object instanceof ITabular) {
	    setTabular((ITabular)object);
	} else if (object instanceof Object[]) {
//System.out.println("_evaluate.set:" + this + ":" + object);
	    setRObjects((Object[])object);
	} else {
//System.out.println("--" + object);
	    if (object instanceof RObjectSlot) {
//System.out.println("---" + this);
		throw (new InternalError());
	    }
	    setRObject(object);
	}
    }

    private RObjectSlot[] _makeParams() {
	if (isBody_) {
	    BodyContent body = getBodyContent();
	    String content = body.getString();
	    List list = new ArrayList();
	    if (isBodyBefore_) {
		list.addAll(parameterValues_);
	    }
	    Document[] docs = _makeBodyDocuments(content);
	    if (docs != null) {
		for (int i = 0;i < docs.length;i++) {
		    list.add(new RObjectSlot(docs[i]));
		}
	    } else {
		list.add(new RObjectSlot(content));
	    }
	    if (!isBodyBefore_) {
		list.addAll(parameterValues_);
	    }
	    RObjectSlot[] params = new RObjectSlot[list.size()];
	    return ((RObjectSlot[])list.toArray(params));
	} else {
	    RObjectSlot[] params = new RObjectSlot[parameterValues_.size()];
	    return ((RObjectSlot[])parameterValues_.toArray(params));
	}
    }

    private Document[] _makeBodyDocuments(String content) { // XXX : more tune
	try {
	    content = "<dummy>" + content + "</dummy>";
	    DocumentBuilderFactory factory
		= DocumentBuilderFactory.newInstance();
	    DocumentBuilder builder = factory.newDocumentBuilder();
	    InputSource source = new InputSource(new StringReader(content));
	    Document doc = builder.parse(source);
	    Element root = doc.getDocumentElement();
	    if (!"dummy".equals(root.getTagName())) {
		throw (new InternalError());
	    }
	    Element[] elements = UDOM.getElements(root);
	    if (elements.length == 0) {
		return (null);
	    }
	    Document[] docs = new Document[elements.length];
	    for (int i = 0;i < elements.length;i++) {
		Document newDoc = builder.newDocument();
		newDoc.appendChild(newDoc.importNode(elements[i], true));
		docs[i] = newDoc;
	    }
	    return (docs);
	} catch (ParserConfigurationException e) {
	    return (null);
	} catch (SAXException e) {
	    return (null);
	} catch (IOException e) {
	    return (null);
	}
    }

    protected Object _doEvaluate(RObjectSlot[] params) throws JspTagException {
	if (params.length == 0) {
	    return (null);
	} else {
	    return (params[params.length - 1].getValue());
	}
    }

    protected final String _resolve(String uri) {
	try {
	    URL url = new URL(uri);
	    return (uri);
	} catch (MalformedURLException e) {
	    return (_resolveLocalPath(uri));
	}
    }

    protected final String _resolveAll(String uri) {
	try {
	    URL url = new URL(uri);
	    return (uri);
	} catch (MalformedURLException e) {
	    return (_resolveLocalPath(uri));
	}
    }

    protected final String _resolveLocalPath(String uri) {
	File file = new File(
	    pageContext.getServletContext().getRealPath(uri)
	);
	try {
	    return (file.toURL().toExternalForm());
	} catch (MalformedURLException ee) {
	    return (null);
	}
    }

    protected final IllegalArgumentException _makeIllegalArgumentException(
	Throwable e
    ) {
	return (ULog.makeIllegalArgumentException(e));
    }

    protected final JspTagException _makeJspTagException(
	Throwable e
    ) {
	return (ULog.makeJspTagException(e));
    }

    protected final void _log(String message) {
	ULog.log(getClass().getName() + message);
    }

    protected final void _log(Throwable e) {
	ULog.log(getClass().getName() + " -> " + e.getMessage());
    }

    protected final void _log(String message, Throwable e) {
	ULog.log(getClass().getName() + message + " -> " + e.getMessage());
    }

    protected final void _logTagInfo() {
	StringBuffer buffer = new StringBuffer();
	boolean cont = false;
	if (name_ != null) {
	    buffer.append("Name:");
	    buffer.append(name_);
	    cont = true;
	}
	if (nameIn_ != null) {
	    if (cont) {
		buffer.append(";");
	    }
	    buffer.append("NameIn:");
	    buffer.append(nameIn_);
	    cont = true;
	}
	if (nameOut_ != null) {
	    if (cont) {
		buffer.append(";");
	    }
	    buffer.append("NameOut:");
	    buffer.append(nameOut_);
	    cont = true;
	}
	if (dialog_ != null) {
	    if (cont) {
		buffer.append(";");
	    }
	    buffer.append("Dialog:");
	    buffer.append(dialog_);
	    cont = true;
	}
	if (dialogIn_ != null) {
	    if (cont) {
		buffer.append(";");
	    }
	    buffer.append("DialogIn:");
	    buffer.append(dialogIn_);
	    cont = true;
	}
	if (dialogOut_ != null) {
	    if (cont) {
		buffer.append(";");
	    }
	    buffer.append("DialogOut:");
	    buffer.append(dialogOut_);
	    cont = true;
	}
	if (dialogSlot_ != null) {
	    if (cont) {
		buffer.append(";");
	    }
	    buffer.append("Slot:");
	    buffer.append(dialogSlot_);
	    cont = true;
	}
	if (dialogSlotIn_ != null) {
	    if (cont) {
		buffer.append(";");
	    }
	    buffer.append("slotIn:");
	    buffer.append(dialogSlotIn_);
	    cont = true;
	}
	if (dialogSlotOut_ != null) {
	    if (cont) {
		buffer.append(";");
	    }
	    buffer.append("SlotOut:");
	    buffer.append(dialogSlotOut_);
	    cont = true;
	}
	ULog.log(new String(buffer));
    }
}
