/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib.tabular;

import java.io.*;
import java.net.URL;
import java.net.MalformedURLException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.relaxer.tabular.*;
import org.relaxer.beans.XHTMLTableTabularBean;

/**
 * XHTMLTableTabularBeanTag
 *
 * @since   Jul. 11, 2001
 * @version Aug.  5, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class XHTMLTableTabularBeanTag extends AbstractTabularBeanTag {
    private XHTMLTableTabularBean bean_ = new XHTMLTableTabularBean();

    public void setSource(String uri) {
	bean_.setSource(_resolve(uri));
    }

    protected ITabular _getTabular() throws JspTagException {
	try {
	    return (bean_.getTabular());
	} catch (IOException e) {
	    throw (new JspTagException(e.getMessage()));
	}
    }
}
