package jp.gr.java_conf.jaba2.SmartDoc.normalizer.hilight;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Word</b> is generated by Relaxer based on hilightData.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="word">
 *   <tag>
 *     <attribute name="tagClass" required="true" type="string"/>
 *     <attribute name="cssClass" required="true" type="string"/>
 *     <attribute name="regex" type="boolean"/>
 *   </tag>
 *   <element name="expression" occurs="*" type="string"/>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="word"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="tagClass" required="true" type="string"/&gt;
 *     &lt;attribute name="cssClass" required="true" type="string"/&gt;
 *     &lt;attribute name="regex" type="boolean"/&gt;
 *   &lt;/tag&gt;
 *   &lt;element name="expression" occurs="*" type="string"/&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version hilightData.rlx 1.0 (Wed May 08 06:33:10 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class Word implements java.io.Serializable {
    private String tagClass_;
    private String cssClass_;
    private Boolean regex_;
    // List<String>
    private java.util.List expression_ = new java.util.ArrayList();

    /**
     * Creates a <code>Word</code>.
     *
     */
    public Word() {
    }

    /**
     * Creates a <code>Word</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Word(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Word</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Word(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Word</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Word(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Word</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Word(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Word</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Word(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Word</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Word(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Word</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Word(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Word</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Word(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Word</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Word(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Word</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Word</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Word</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        tagClass_ = URelaxer.getAttributePropertyAsString(element, "tagClass");
        cssClass_ = URelaxer.getAttributePropertyAsString(element, "cssClass");
        regex_ = URelaxer.getAttributePropertyAsBooleanObject(element, "regex");
        expression_ = URelaxer.getElementPropertyAsStringListByStack(stack, "expression");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("word");
        int size;
        URelaxer.setAttributePropertyByString(element, "tagClass", this.tagClass_);
        URelaxer.setAttributePropertyByString(element, "cssClass", this.cssClass_);
        if (this.regex_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "regex", this.regex_);
        }
        URelaxer.setElementPropertyByStringList(element, "expression", this.expression_);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Word</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Word</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Word</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Word</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Word</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Word</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>tagClass</b>.
     *
     * @return String
     */
    public final String getTagClass() {
        return (tagClass_);
    }

    /**
     * Sets the String property <b>tagClass</b>.
     *
     * @param tagClass
     */
    public final void setTagClass(String tagClass) {
        this.tagClass_ = tagClass;
    }

    /**
     * Gets the String property <b>cssClass</b>.
     *
     * @return String
     */
    public final String getCssClass() {
        return (cssClass_);
    }

    /**
     * Sets the String property <b>cssClass</b>.
     *
     * @param cssClass
     */
    public final void setCssClass(String cssClass) {
        this.cssClass_ = cssClass;
    }

    /**
     * Gets the boolean property <b>regex</b>.
     *
     * @exception IllegalStateException
     * @return boolean
     */
    public boolean getRegex() throws IllegalStateException {
        if (regex_ == null) {
            throw (new IllegalStateException("regex_"));
        }
        return (regex_.booleanValue());
    }

    /**
     * Gets the boolean property <b>regex</b>.
     *
     * @exception IllegalStateException
     * @return Boolean
     */
    public Boolean getRegexAsBoolean() throws IllegalStateException {
        return (regex_);
    }

    /**
     * Check the boolean property <b>regex</b>.
     *
     * @return boolean
     */
    public boolean checkRegex() {
        return (regex_ != null);
    }

    /**
     * Sets the boolean property <b>regex</b>.
     *
     * @param regex
     */
    public void setRegex(boolean regex) {
        this.regex_ = new Boolean(regex);
    }

    /**
     * Sets the boolean property <b>regex</b>.
     *
     * @param regex
     */
    public void setRegex(Boolean regex) {
        this.regex_ = regex;
    }

    /**
     * Gets the String property <b>expression</b>.
     *
     * @return String[]
     */
    public final String[] getExpression() {
        String[] array = new String[expression_.size()];
        return ((String[])expression_.toArray(array));
    }

    /**
     * Sets the String property <b>expression</b>.
     *
     * @param expression
     */
    public final void setExpression(String[] expression) {
        this.expression_.clear();
        this.expression_.addAll(java.util.Arrays.asList(expression));
    }

    /**
     * Sets the String property <b>expression</b>.
     *
     * @param expression
     */
    public final void setExpression(String expression) {
        this.expression_.clear();
        this.expression_.add(expression);
    }

    /**
     * Adds the String property <b>expression</b>.
     *
     * @param expression
     */
    public final void addExpression(String expression) {
        this.expression_.add(expression);
    }

    /**
     * Gets number of the String property <b>expression</b>.
     *
     * @return int
     */
    public final int getExpressionCount() {
        return (expression_.size());
    }

    /**
     * Gets the String property <b>expression</b> by index.
     *
     * @param index
     * @return String
     */
    public final String getExpression(int index) {
        return ((String)expression_.get(index));
    }

    /**
     * Sets the String property <b>expression</b> by index.
     *
     * @param index
     * @param expression
     */
    public final void setExpression(int index, String expression) {
        this.expression_.set(index, expression);
    }

    /**
     * Remove the String property <b>expression</b> by index.
     *
     * @param index
     */
    public final void removeExpression(int index) {
        expression_.remove(index);
    }

    /**
     * Remove the String property <b>expression</b> by object.
     *
     * @param expression
     */
    public final void removeExpression(String expression) {
        this.expression_.remove(expression);
    }

    /**
     * Clear the String property <b>expression</b>.
     *
     */
    public final void clearExpression() {
        expression_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<word");
        buffer.append(" tagClass=\"");
        buffer.append(URelaxer.escapeAttrQuot(getTagClass()));
        buffer.append("\"");
        buffer.append(" cssClass=\"");
        buffer.append(URelaxer.escapeAttrQuot(getCssClass()));
        buffer.append("\"");
        if (regex_ != null) {
            buffer.append(" regex=\"");
            buffer.append(new Boolean(getRegex()).toString());
            buffer.append("\"");
        }
        buffer.append(">");
        size = getExpressionCount();
        for (int i = 0;i < size;i++) {
            buffer.append("<expression>");
            buffer.append(URelaxer.escapeCharData(getExpression(i)));
            buffer.append("</expression>");
        }
        buffer.append("</word>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<word");
        buffer.print(" tagClass=\"");
        buffer.print(URelaxer.escapeAttrQuot(getTagClass()));
        buffer.print("\"");
        buffer.print(" cssClass=\"");
        buffer.print(URelaxer.escapeAttrQuot(getCssClass()));
        buffer.print("\"");
        if (regex_ != null) {
            buffer.print(" regex=\"");
            buffer.print(new Boolean(getRegex()).toString());
            buffer.print("\"");
        }
        buffer.print(">");
        size = getExpressionCount();
        for (int i = 0;i < size;i++) {
            buffer.print("<expression>");
            buffer.print(URelaxer.escapeCharData(getExpression(i)));
            buffer.print("</expression>");
        }
        buffer.print("</word>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTagClassAsString() {
        return (URelaxer.getString(getTagClass()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCssClassAsString() {
        return (URelaxer.getString(getCssClass()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getRegexAsString() {
        return (URelaxer.getString(getRegex()));
    }

    /**
     * Gets the property value as String array.
     *
     * @return String[]
     */
    public String[] getExpressionAsString() {
        int size = getExpressionCount();
        String[] array = new String[size];
        for (int i = 0;i < size;i++) {
            array[i] = URelaxer.getString(getExpression(i));
        }
        return (array);
    }

    /**
     * Gets the property value by index as String.
     *
     * @param index
     * @return String
     */
    public String getExpressionAsString(int index) {
        return (URelaxer.getString(getExpression(index)));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTagClassByString(String string) {
        setTagClass(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCssClassByString(String string) {
        setCssClass(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setRegexByString(String string) {
        setRegex(new Boolean(string).booleanValue());
    }

    /**
     * Sets the property value by String array.
     *
     * @param strings
     */
    public void setExpressionByString(String[] strings) {
        if (strings.length > 0) {
            String string = strings[0];
            setExpression(string);
            for (int i = 1;i < strings.length;i++) {
                string = strings[i];
                addExpression(string);
            }
        }
    }

    /**
     * Sets the property value by String via index.
     *
     * @param index
     * @param value
     */
    public void setExpressionByString(int index, String value) {
        setExpression(index, value);
    }

    /**
     * Adds the property value by String.
     *
     * @param string
     */
    public void addExpressionByString(String string) {
        addExpression(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Word</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "word")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while ((child = target.peekElement()) != null) {
            if (!URelaxer.isTargetElement(child, "expression")) {
                break;
            }
            target.popElement();
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Word</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Word</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
