package jp.gr.java_conf.jaba2.awt;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.event.EventListenerList;

/**
 * ActionDialog
 *
 * @since   Jun. 18, 1998
 * @version Oct. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class ActionDialog extends JDialog {
    protected String command_ = "";
    protected Frame frame_;
    protected EventListenerList listeners_ = new EventListenerList();

    public ActionDialog(Frame frame, String title, boolean modal) {
	super(frame, title, modal);
	frame_ = frame;
    }

    // Component
    public void setVisible(boolean visible) {
	if (visible) {
	    Rectangle frameBounds = frame_.getBounds();
	    Rectangle dialogBounds = getBounds();
	    int x = (frameBounds.width - dialogBounds.width) / 2;
	    int y = (frameBounds.height - dialogBounds.height) / 2;
	    if (x >= 0) {
		x += frameBounds.x;
	    } else {
		x = frameBounds.x;
	    }
	    if (y >= 0) {
		y += frameBounds.y;
	    } else {
		y = frameBounds.y;
	    }
	    setLocation(x, y);
	} else {
	    dispose();
	}
	super.setVisible(visible);
    }

    public void setActionCommand(String command) {
	command_ = command;
    }

    public String getActionCommand() {
	return (command_);
    }

    public void addActionListener(ActionListener l) {
	listeners_.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
	listeners_.remove(ActionListener.class, l);
    }

    protected void _fireActionPerformed() {
	_fireActionPerformed(
	    new ActionEvent(
		this,
		ActionEvent.ACTION_PERFORMED,
		command_
	    )
	);
    }

    protected void _fireActionPerformed(ActionEvent evt) {
	Object[] listeners = listeners_.getListenerList();
	for (int i = listeners.length - 2;i >= 0;i -= 2) {
	    if (listeners[i] == ActionListener.class) {
		((ActionListener)listeners[i + 1]).actionPerformed(evt);
	    }
	}
    }
}
