/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.graph;

import java.util.*;

/**
 * AbstractGraphModel
 *
 * @since   Dec.  1, 1998
 * @version Feb.  8, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class AbstractGraphModel extends Observable
    implements GraphModel {

    protected List nodes_ = new ArrayList();
    protected List links_ = new ArrayList();
    protected List docks_ = new ArrayList();

    public void sync() {
	notifyObservers();
    }

    public void add(GraphObject gobj) {
	if (gobj instanceof GraphNode) {
	    addNode((GraphNode)gobj);
	} else if (gobj instanceof GraphLink) {
	    addLink((GraphLink)gobj);
	} else if (gobj instanceof GraphDock) {
	    addDock((GraphDock)gobj);
	} else {
	    throw (new InternalError());
	}
	setChanged();
    }

    public void remove(GraphObject gobj) {
	if (gobj instanceof GraphNode) {
	    removeNode((GraphNode)gobj);
	} else if (gobj instanceof GraphLink) {
	    removeLink((GraphLink)gobj);
	} else if (gobj instanceof GraphDock) {
	    removeDock((GraphDock)gobj);
	} else {
	    throw (new InternalError());
	}
	setChanged();
    }

    public GraphObject[] getObjects() {
	int nNodes = nodes_.size();
	int nLinks = links_.size();
	int nDocks = docks_.size();
	int nObjects = nNodes + nLinks + nDocks;
	GraphObject[] gobjects = new GraphObject[nObjects];
	int index = 0;
	for (int i = 0;i < nNodes;i++) {
	    gobjects[index++] = (GraphObject)nodes_.get(i);
	}
	for (int i = 0;i < nLinks;i++) {
	    gobjects[index++] = (GraphObject)links_.get(i);
	}
	for (int i = 0;i < nDocks;i++) {
	    gobjects[index++] = (GraphObject)docks_.get(i);
	}
	return (gobjects);
    }

/*
    public GraphObjectDescriptor[] getObjectDescriptors() {
	int nNodes = nodes_.size();
	int nLinks = links_.size();
	int nDocks = docks_.size();
	int nObjects = nNodes + nLinks + nDocks;
	GraphObjectDescriptor[] descs = new GraphObjectDescriptor[nObjects];
	int index = 0;
	for (int i = 0;i < nNodes;i++) {
	    descs[index++] = new GraphObjectDescriptor(
		(GraphObject)nodes_.get(i),
		new Integer(20)	// XXX
	    );
	}
	for (int i = 0;i < nLinks;i++) {
	    descs[index++] = new GraphObjectDescriptor(
		(GraphObject)links_.get(i),
		new Integer(10)	// XXX
	    );
	}
	for (int i = 0;i < nDocks;i++) {
	    descs[index++] = new GraphObjectDescriptor(
		(GraphObject)docks_.get(i),
		new Integer(0)	// XXX
	    );
	}
	return (descs);
    }
*/

    public void addNode(GraphNode node) {
	nodes_.add(node);
	setChanged();
    }

    public void removeNode(GraphNode node) {
	GraphLink[] links = node.getLinks();
	for (int i = 0;i < links.length;i++) {
	    GraphLink link = links[i];
	    link.removeNode(node);
	    if (!link.isValid()) {
		removeLink(link);
	    }
	}
	nodes_.remove(node);
	setChanged();
    }

    public void addLink(GraphLink link) {
	links_.add(link);
	setChanged();
    }

    public void removeLink(GraphLink link) {
	GraphNode[] nodes = link.getLinkNodes();
	for (int i = 0;i < nodes.length;i++) {
	    nodes[i].removeLink(link);
	}
	links_.remove(link);
	setChanged();
    }

    public void addDock(GraphDock dock) {
	docks_.add(dock);
	setChanged();
    }

    public void removeDock(GraphDock dock) {
	docks_.remove(dock);
	setChanged();
    }

    public GraphNode[] getNodes() {
	GraphNode[] nodes = new GraphNode[nodes_.size()];
	return ((GraphNode[])nodes_.toArray(nodes));
    }

    public GraphLink[] getLinks() {
	GraphLink[] links = new GraphLink[links_.size()];
	return ((GraphLink[])links_.toArray(links));
    }

    public GraphDock[] getDocks() {
	GraphDock[] docks = new GraphDock[docks_.size()];
	return ((GraphDock[])docks_.toArray(docks));
    }
}
