/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus.domcomps;

import java.io.File;
import java.io.IOException;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.UXML;
import jp.gr.java_conf.jaba2.io.UFile;
import jp.gr.java_conf.jaba2.dombus.*;

/**
 * DOMBusXMLPackager
 *
 * @deprecated
 * @see jp.gr.java_conf.jaba2.dombus.packager.DOMBusXMLPackager
 *
 * @since   Apr. 19, 2000
 * @version Aug. 25, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMBusXMLPackager extends AbstractDOMBusComponent {
    public boolean init() {
	return (false);
    }

    public void start() {
    }

    public Object fire(DOMBusSignal signal) {
	String urlName = (String)signal.getProperty("url");
	if (urlName == null) {
	    urlName = "output.xml";
	}
	String encoding = (String)signal.getProperty("encoding");
	if (encoding == null) {
	    encoding = "UTF-8";
	}
	Document doc = (Document)signal.getContent();
	String text = _makeXMLDocument(doc, encoding);
	File file = new File(urlName);
	try {
	    UFile.createFile(file, text, encoding);
	} catch (IOException e) {
	    throw (new DOMBusException(e));
	}
	return (null);
    }

    private String _makeXMLDocument(Document doc, String encoding) {
	String text = UXML.doc2String4Print(doc, encoding);
	return (text);
    }
}


