/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.type;

/**
 * ClassPowerType
 *
 * @since   Mar. 29, 2000
 * @version Dec. 10, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class ClassPowerType implements IPowerType {
    private Class type_;

    public ClassPowerType(Class type) {
	type_ = type;
    }

    public ClassPowerType(Object object) {
	type_ = object.getClass();
    }

    public boolean isValid(Object object) {
	return (type_.isInstance(object));
    }

    public Class getJavaType() {
	return (type_);
    }

    public String getXMLTypeName() {
	return (null);
    }

    public String getMIMETypeName() {
	return (null);
    }

    public String getEncoding() {
	return (null);
    }
}
