/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.util;

import java.util.*;

/**
 * IntMap
 *
 * @since   Jan. 20, 2000
 * @version Feb. 24, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class IntMap extends HashMap {
    public void put(int i, Object data) {
	put(new Integer(i), data);
    }

    public Object get(int i) {
	return (get(new Integer(i)));
    }

    public boolean containsKey(int i) {
	return (containsKey(new Integer(i)));
    }

    public int[] getKeys() {
	Set keys = keySet();
	Integer[] integers = new Integer[keys.size()];
	integers = (Integer[])keys.toArray(integers);
	int[] ints = new int[integers.length];
	for (int i = 0;i < integers.length;i++) {
	    ints[i] = integers[i].intValue();
	}
	Arrays.sort(ints);
	return (ints);
    }
}
