/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.converter;

import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.UXML;

/**
 * TextConverter
 *
 * @since   Aug.  6, 1999
 * @version Aug.  6, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class TextConverter extends AbstractConverter {
    public Node[] string2Nodes(Document doc, String string) {
	return (uString2Nodes(doc, string));
    }

    public String nodes2String(Node[] nodes) {
	return (uNodes2String(nodes));
    }

    public static Node[] uString2Nodes(Document doc, String string) {
	Text text = doc.createTextNode(string);
	return (new Node[] { text });
    }

    public static String uNodes2String(Node parent) {
	return (uNodes2String(UXML.listNodes(parent)));
    }

    public static String uNodes2String(Node[] nodes) {
	return (UXML.nodes2Text(nodes));
    }
}
