/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.datatype;

import java.util.*;
import java.io.StringReader;
import java.io.IOException;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import jp.gr.java_conf.jaba2.xml.*;

/**
 * DComplex
 *
 * @since   Jun. 29, 2002
 * @version Jul. 14, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class DComplex extends Datatype {
    private String expr_;
    private Document doc_;

    public DComplex() {
    }

    public DComplex(Element element) {
	throw (new UnsupportedOperationException());
    }

    public DComplex(String expr) {
	expr_ = expr;
	try {
	    DocumentBuilderFactory factory
		= DocumentBuilderFactory.newInstance();
	    factory.setNamespaceAware(true);
	    DocumentBuilder builder = factory.newDocumentBuilder();
	    doc_ = builder.parse(new InputSource(new StringReader(expr)));
	} catch (IOException e) {
	    doc_ = null;
	} catch (SAXException e) {
	    doc_ = null;
	} catch (ParserConfigurationException e) {
	    doc_ = null;
	}
    }

    public String getName() {
	return ("complex");
    }

    public String getExpr() {
	return (expr_);
    }

    public Document getExprDoc() {
	return (doc_);
    }

/*
    public String getRefName() {
	String mark = "<ref name=\"";
	int markLength = mark.length();
	int index = expr_.indexOf(mark);
	if (index == -1) {
	    return (null);
	}
	int last = expr_.indexOf("\"", markLength);
	if (last == -1) {
	    return (null);
	}
	return (expr_.substring(markLength, last));
    }
*/

    public Object makeObject(String cdata) {
	return (cdata);
    }
}
