/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.processor;

import java.io.*;
import java.net.URL;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import com.ibm.xml.parsers.*;
import jp.gr.java_conf.jaba2.xml.IProcessor;
import jp.gr.java_conf.jaba2.xml.sax.SimpleErrorHandler;

/**
 * XML4J2Processor
 *
 * @since   Aug. 14, 1999
 * @version Aug. 15, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class XML4J2Processor extends AbstractProcessor {
    public XML4J2Processor() {
    }

    public Document parseDocument(URL url) throws IOException {
	NonValidatingDOMParser parser = new NonValidatingDOMParser();
	parser.setErrorHandler(getErrorHandler());
	parser.setEntityResolver(getEntityResolver());
	try {
	    parser.parse(url.toExternalForm());
	} catch (SAXException e) {
	    throw (new IOException(e.getMessage()));
	}
	return (parser.getDocument());
    }

    public Document parseDocumentByText(String text) throws IOException {
	NonValidatingDOMParser parser = new NonValidatingDOMParser();
	parser.setErrorHandler(getErrorHandler());
	parser.setEntityResolver(getEntityResolver());
	try {
	    parser.parse(new InputSource(new StringReader(text)));
	} catch (SAXException e) {
	    throw (new IOException(e.getMessage()));
	}
	return (parser.getDocument());
    }

    public Document parseValidDocument(URL url) throws IOException {
	DOMParser parser = new DOMParser();
	parser.setErrorHandler(getErrorHandler());
	parser.setEntityResolver(getEntityResolver());
	try {
	    parser.parse(url.toExternalForm());
	} catch (SAXException e) {
	    throw (new IOException(e.getMessage()));
	}
	return (parser.getDocument());
    }

    public Document parseValidDocumentByText(String text) throws IOException {
	DOMParser parser = new DOMParser();
	parser.setErrorHandler(getErrorHandler());
	parser.setEntityResolver(getEntityResolver());
	try {
	    parser.parse(new InputSource(new StringReader(text)));
	} catch (SAXException e) {
	    throw (new IOException(e.getMessage()));
	}
	return (parser.getDocument());
    }

    public Document newDocument() {
	return (new com.ibm.xml.dom.DocumentImpl());
    }
}
