/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.datatype.*;
import jp.gr.java_conf.jaba2.xml.relax.raw.RElement;

/**
 * CElement
 *
 * @since   Dec. 22, 1999
 * @version Aug. 30, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class CElement extends CNode implements ICParticle, ICContentModel {
    private String pattern_;
    private String name_;
    private String label_;
    private String type_;
    private COccurs occurs_;
    private Datatype datatype_;
    private CModule module_;

    public CElement(
	String pattern,
	String name,
	String occurs,
	CModule module
    ) {
	pattern_ = pattern;
	name_ = name;
	occurs_ = new COccurs(occurs);
	module_ = module;
    }

    public void setLabel(String label) {
	label_ = label;
    }

    public void setType(String type) {
	type_ = type;
	datatype_ = module_.makeDatatype(type);
    }

    public CElement(RElement relement, CModule module) {
	super(relement);
	pattern_ = relement.getPattern();
	name_ = relement.getName();
	label_ = relement.getLabel();
	type_ = relement.getType();
//	if (type_ == null) {
//	    throw (new CSyntaxErrorException(
//		"No type in element \"" + name_ + "\""));
//	}
	occurs_ = new COccurs(relement.getOccurs());
	if (type_ != null) {
	    datatype_ = module.makeDatatype(type_, relement.getBase());
	}
	module_ = module;
    }

    public final String getPattern() {
	return (pattern_);
    }

    public final String getName() {
	return (name_);
    }

    public final String getLabel() {
	return (label_);
    }

    public final String getType() {
	return (type_);
    }

    public final COccurs getOccurs() {
	return (occurs_);
    }

    public final Datatype getDatatype() {
	return (datatype_);
    }

    public final void setDatatype(Datatype datatype) {
	datatype_ = datatype;
    }
}
