/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.datatype.IXMLDatatype;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EAttributeNode
 *
 * @since   Apr. 19, 2002
 * @version Nov. 17, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class EAttributeNode extends ERuleNode implements IEOccurs {
    private String attrName_;
    private String namespace_;
    private boolean isAnd_;
    private IXMLDatatype datatype_;

    public EAttributeNode(
	String name,
	String labelName,
	IXMLDatatype datatype
    ) {
	super("attribute", labelName);
	attrName_ = name;
	namespace_ = "";
	isAnd_ = true;
	datatype_ = datatype;
	if (attrName_ == null || "".equals(attrName_)) {
	    throw (new InternalError());
	}
	if (datatype == null) {
	    throw (new InternalError());
	}
	setAttribute("attrName", name);
    }

    public EAttributeNode(
	String name,
	String ns,
	String labelName,
	IXMLDatatype datatype
    ) {
	super("attribute", labelName);
	attrName_ = name;
	if (ns == null) {
	    namespace_ = "";
	} else {
	    namespace_ = ns;
	}
	isAnd_ = true;
	datatype_ = datatype;
	if (attrName_ == null || "".equals(attrName_)) {
	    throw (new InternalError());
	}
	if (datatype == null) {
	    throw (new InternalError());
	}
	setAttribute("attrName", name);
	if ("".equals(namespace_)) {
	    setAttribute("ns", ns);
	}
    }

/*
    public EAttributeNode(CAttribute attribute) {
	super("attribute");
	attrName_ = attribute.getName();
	namespace_ = attribute.getNamespace();
	isAnd_ = attribute.isAnd();
	datatype_ = attribute.getDatatype();
    }
*/

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }

    public String getAttrName() {
	return (attrName_);
    }

    public String getNamespace() {
	return (namespace_);
    }

    public IXMLDatatype getDatatype() {
	return (datatype_);
    }

    public void setDatatype(IXMLDatatype datatype) {
	datatype_ = datatype;
	if (datatype == null) {
	    throw (new InternalError());
	}
    }

    public boolean isNameClass() {
	return (UERule.isNameClass(attrName_));
    }

    public boolean isAnd() {
	return (isAnd_);
    }
}
