/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.datatype.IXMLDatatype;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EAttributeSlot
 *
 * @since   Jan.  3, 2000
 * @version Nov.  7, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class EAttributeSlot extends ESlotNode {
    private String attrName_;
    private boolean isRequired_;
    private boolean isAnd_;
    private String[] enumerations_;
    private String defaultValue_;
    private String namespace_;
    private EAttributeNode attributeNode_;

    public EAttributeSlot(String attrName, IXMLDatatype type) {
	super("attributeSlot", type);
	attrName_ = attrName;
	setAttribute("attr", attrName);
    }

    public EAttributeSlot(EAttributeSlot aSlot) {
	this(aSlot.getAttrName(), aSlot.getDatatype());
	setRequired(aSlot.isRequired());
	setAnd(aSlot.isAnd());
	enumerations_ = aSlot.getEnumerations();
	namespace_ = aSlot.getNamespace();
	attributeNode_ = aSlot.attributeNode_;
    }

    public final String getAttrName() {
	return (attrName_);
    }

    public final boolean isRequired() {
	return (isRequired_);
    }

    public final void setRequired(boolean required) {
	isRequired_ = required;
	setAttribute("required", required ? "true" : "false");
    }

    public final boolean isAnd() {
	return (isAnd_);
    }

    public final void setAnd(boolean and) {
	isAnd_ = and;
	setAttribute("and", and ? "true" : "false");
    }

    public final void setEnumerations(String[] enumerations) {
	enumerations_ = enumerations;
    }

    public final String getNamespace() {
	return (namespace_);
    }

    public final void setNamespace(String namespace) {
	namespace_ = namespace;
    }

    public final String[] getEnumerations() {
	if (enumerations_ == null) {
	    return (null);
	} else {
	    return ((String[])enumerations_.clone());
	}
    }

    public final String getDefaultValue() { // XXX
	return (defaultValue_);
    }

    public final void setAttributeNode(EAttributeNode aNode) {
	attributeNode_ = aNode;
    }

    public final EAttributeNode getAttributeNode() {
	return (attributeNode_);
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }
}
