/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

/**
 * SyncCounter
 *
 * @since   Dec. 14, 2000
 * @version Jun.  9, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class SyncCounter {
    private int counter_;

    public SyncCounter(int counter) {
	counter_ = counter;
    }

    public synchronized void done() {
	counter_--;
	if (counter_ == 0) {
	    notifyAll();
	} else if (counter_ < 0) {
	    throw (new InternalError());
	}
//System.out.println("done (" + counter_ + ") : " + Thread.currentThread());
    }

    public synchronized void sync() {
	try {
	    while (counter_ != 0) {
		wait();
	    }
	} catch (InterruptedException e) {
	    throw (new InternalError());
	}
	if (counter_ != 0) {
	    throw (new InternalError());
	}
    }
}
