/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relaxng;

import java.util.Stack;
import jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng.*;

/**
 * NsResolver
 *
 * @since   Nov.  3, 2002
 * @version Dec.  5, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class NsResolver implements IRVisitor {
    private String rootNs_;
    // Stack<String>
    private Stack stack_ = new Stack();

    public NsResolver(String ns) {
	rootNs_ = ns;
	_pushNs(rootNs_);
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNGrammar visitable) {
//	System.out.println("[" + visitable.getNs() + "] <= " + _peekNs());
	String newNs = visitable.getNs();
	if (newNs == null) {
	    newNs = _peekNs();
	    visitable.setNs(newNs);
	}
	_pushNs(newNs);
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNGrammar visitable) {
	_popNs();
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNDefine visitable) {
//	System.out.println("[" + visitable.getNs() + "] <= " + _peekNs());
	String newNs = visitable.getNs();
	if (newNs == null) {
	    newNs = _peekNs();
	    visitable.setNs(newNs);
	}
	_pushNs(newNs);
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNDefine visitable) {
	_popNs();
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNElement visitable) {
	String fullname = visitable.getName();
	if (fullname == null) {
	    return (true);
	}
	String prefix = _getPrefix(fullname);
	String name = _getName(fullname);
	if ("xml".equals(prefix)) {
	    visitable.setNs("http://www.w3.org/XML/1998/namespace");
	    visitable.setName(name);
	} else if ("xmlns".equals(prefix)) {
	    visitable.setNs("http://www.w3.org/2000/xmlns/");
	    visitable.setName(name);
	} else if (prefix != null) {
	    visitable.setNs(
		_getNamespaceByPrefix(prefix, visitable.getRNSContext())
	    );
	} else {
/*
	    String newNs = visitable.getNs();
	    if (newNs == null) {
		newNs = _peekNs();
		visitable.setNs(newNs);
	    }
	    _pushNs(newNs);
*/
	}
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNElement visitable) {
/*
	String fullname = visitable.getName();
	if (fullname == null) {
	    return;
	}
	String prefix = _getPrefix(fullname);
	String name = _getName(fullname);
	if ("xml".equals(prefix)) {
	    // do nothing
	} else if ("xmlns".equals(prefix)) {
	    // do nothing
	} else if (prefix != null) {
	    // do nothing
	} else {
	    _popNs();
	}
*/
        return;
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNNsName visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNNsName visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNExcept visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNExcept visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNName visitable) {
	String fullname = visitable.getContent();
	if (fullname == null) {
	    return (true);	// XXX
	}
	String prefix = _getPrefix(fullname);
	String name = _getName(fullname);
	if ("xml".equals(prefix)) {
	    visitable.setNs("http://www.w3.org/XML/1998/namespace");
	    visitable.setContent(name);
	} else if ("xmlns".equals(prefix)) {
	    visitable.setNs("http://www.w3.org/2000/xmlns/");
	    visitable.setContent(name);
	} else if (prefix != null) {
	    visitable.setNs(
		_getNamespaceByPrefix(prefix, visitable.getRNSContext())
	    );
	}
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNName visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNAnyName visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNAnyName visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNNameChoice visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNNameChoice visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNAttribute visitable) {
	String fullname = visitable.getName();
	if (fullname == null) {
	    return (true);
	}
	String prefix = _getPrefix(fullname);
	String name = _getName(fullname);
	if ("xml".equals(prefix)) {
	    visitable.setNs("http://www.w3.org/XML/1998/namespace");
	    visitable.setName(name);
	} else if ("xmlns".equals(prefix)) {
	    visitable.setNs("http://www.w3.org/2000/xmlns/");
	    visitable.setName(name);
	} else if (prefix != null) {
	    visitable.setNs(
		_getNamespaceByPrefix(prefix, visitable.getRNSContext())
	    );
	}
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNAttribute visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNData visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNData visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNParam visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNParam visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNValue visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNValue visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNRef visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNRef visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNText visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNText visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNList visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNList visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNNotAllowed visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNNotAllowed visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNEmpty visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNEmpty visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNTextChoice visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNTextChoice visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNTextOptional visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNTextOptional visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNTextOneOrMore visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNTextOneOrMore visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNTextZeroOrMore visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNTextZeroOrMore visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNExternalRef visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNExternalRef visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNParentRef visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNParentRef visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNGroup visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNGroup visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNChoice visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNChoice visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNInterleave visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNInterleave visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNMixed visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNMixed visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNOptional visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNOptional visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNZeroOrMore visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNZeroOrMore visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNOneOrMore visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNOneOrMore visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNInclude visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNInclude visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNStart visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNStart visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RNDiv visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RNDiv visitable) {
    }

    private String _getNamespaceByNamePrefix(
	RNSContext nsContext,
	String name
    ) {
	int index = name.indexOf(":");
	if (index == -1) {
	    return (null);
	}
	String prefix = name.substring(0, index);
	return (nsContext.getUriByPrefix(prefix));
    }

    private String _getNamespaceByPrefix(
	String prefix,
	RNSContext nsContext
    ) {
	return (nsContext.getUriByPrefix(prefix));
    }

    private String _getPrefix(String fullname) {
	int index = fullname.indexOf(":");
	if (index == -1) {
	    return (null);
	} else {
//System.out.println("prefix = " + fullname.substring(0, index));
	    return (fullname.substring(0, index));
	}
    }

    private String _getName(String fullname) {
	int index = fullname.indexOf(":");
	if (index == -1) {
	    return (fullname);
	} else {
	    return (fullname.substring(index + 1));
	}
    }

    private void _pushNs(String ns) {
	stack_.push(ns);
    }

    private String _popNs() {
	return ((String)stack_.pop());
    }

    private String _peekNs() {
	return ((String)stack_.peek());
    }
}
