/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relaxng;

import java.util.*;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.util.MultiValueMap;
import jp.gr.java_conf.jaba2.xml.*;
import jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng.*;

/**
 * RNGGrammarBuilder
 *
 * @since   Aug. 17, 2002
 * @version Dec. 17, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class RNGGrammarBuilder {
    private String baseUri_;
    private Context root_;
    private Context current_;
    private Set names_ = new HashSet();
    private List starts_ = new ArrayList();

    public RNGGrammarBuilder(RNGrammar grammar, String baseUri) {
	baseUri_ = baseUri;
	current_ = root_ = new Context();
	current_.baseUri = baseUri;
	current_.ns = grammar.getNs();
//System.out.println(grammar);
	_expandGrammar(grammar);
    }

    public RNGGrammarBuilder(RNElement element, String baseUri) {
	baseUri_ = baseUri;
	current_ = root_ = new Context();
	current_.baseUri = baseUri;
	current_.ns = element.getNs();
//System.out.println(grammar);
	_expandElement(element);
    }

    public List getDefines() {
	ArrayList list = new ArrayList();
	Iterator iter = names_.iterator();
	while (iter.hasNext()) {
	    String name = (String)iter.next();
	    list.add(_getDefine(root_, name));
	}
	return (list);
    }

    private RNDefine _getDefine(Context context, String name) {
	List childrenDefines = new ArrayList();
	RNDefine[] defines = (RNDefine[])context.defines.get(name);
	if (!(defines == null || defines.length == 0)) {
	    childrenDefines.addAll(Arrays.asList(defines));
	}
	_getChildrenDefines(context, name, childrenDefines);
	switch (childrenDefines.size()) {
	case 0:
	    return (null);
	case 1:
	    return ((RNDefine)childrenDefines.get(0));
	default:
	    if (_isChoice(childrenDefines)) {
		return (_getChoiceDefine(name, childrenDefines, context));
	    } else if (_isInterleave(childrenDefines)) {
		return (_getInterleaveDefine(name, childrenDefines, context));
	    } else {
		throw (new RNGSyntaxErrorException("Multiple definitions of \"" + name + "\" without \"combine\" attribute"));
	    }
	}
    }

/*
    private RNDefine _getDefine(Context context, String name) {
	RNDefine[] defines = (RNDefine[])context.defines.get(name);
	if (defines == null || defines.length == 0) {
	    List childrenDefines = new ArrayList();
	    int size = context.children.size();
	    for (int i = 0;i < size;i++) {
		Context childContext = (Context)context.children.get(i);
		RNDefine childDefine = _getDefine(childContext, name);
		if (childDefine != null) {
		    childrenDefines.add(childDefine);
		}
	    }
	    switch (childrenDefines.size()) {
	    case 0:
		return (null);
	    case 1:
		return ((RNDefine)childrenDefines.get(0));
	    default:
		if (_isChoice(childrenDefines)) {
		    return (_getChoiceDefine(name, childrenDefines));
		} else if (_isInterleave(childrenDefines)) {
		    return (_getInterleaveDefine(name, childrenDefines));
		} else {
		    throw (new RNGSyntaxErrorException("Multiple definitions of \"" + name + "\" without \"combine\" attribute"));
		}
	    }
	} else if (defines.length == 1) {
	    RNDefine define = defines[0];
	    if ("choice".equals(define.getCombine())) {
		List childrenDefines = new ArrayList();
		childrenDefines.add(define);
		_getChildrenDefines(context, name, childrenDefines);
		return (_getChoiceDefine(name, childrenDefines));
	    } else if ("interleave".equals(define.getCombine())) {
		List childrenDefines = new ArrayList();
		childrenDefines.add(define);
		_getChildrenDefines(context, name, childrenDefines);
		return (_getInterleaveDefine(name, childrenDefines));
	    } else {
		return (define);
	    }
	} else {
	    if (_isChoice(defines)) {
		List childrenDefines = new ArrayList();
		childrenDefines.addAll(Arrays.asList(defines));
		_getChildrenDefines(context, name, childrenDefines);
		return (_getChoiceDefine(name, childrenDefines));
	    } else if (_isInterleave(defines)) {
		List childrenDefines = new ArrayList();
		childrenDefines.addAll(Arrays.asList(defines));
		_getChildrenDefines(context, name, childrenDefines);
		return (_getInterleaveDefine(name, childrenDefines));
	    } else {
		throw (new RNGSyntaxErrorException("Multiple definitions of \"" + name + "\" without \"combine\" attribute"));
	    }
	}
    }
*/

    private void _getChildrenDefines(Context context, String name, List list) {
	int size = context.children.size();
	for (int i = 0;i < size;i++) {
	    Context childContext = (Context)context.children.get(i);
	    RNDefine[] defines = (RNDefine[])childContext.defines.get(name);
	    if (!(defines == null || defines.length == 0)) {
		list.addAll(Arrays.asList(defines));
	    }
	    _getChildrenDefines(childContext, name, list);
	}
    }

    private RNDefine _getChoiceDefine(
	String name,
	List defines,
	Context context
    ) {
	RNDefine newDefine = new RNDefine();
	newDefine.setName(name);
	newDefine.setNs(context.ns);
	RNChoice choice = new RNChoice();
	newDefine.addElementHedge(choice);
	int size = defines.size();
	if (size == 0) {
	    throw (new InternalError());
	} else if (size == 1) {
	    return ((RNDefine)defines.get(0));
	} else {
	    for (int i = 0;i < size;i++) {
		RNDefine oldDefine = (RNDefine)defines.get(i);
		String oldNs = oldDefine.getNs();
//System.out.println("name = " + name + ", old ns = " + oldNs);
		RNGroup group = new RNGroup();
		IRNElementHedgeChoice[] children
		    = oldDefine.getElementHedge();
		_adjustNs(children, oldNs);
		group.setElementHedge(children);
		choice.addElementHedge(group);
	    }
//System.out.println(newDefine);
	    return (newDefine);
	}
    }

    private RNDefine _getInterleaveDefine(
	String name,
	List defines,
	Context context
    ) {
	RNDefine newDefine = new RNDefine();
	newDefine.setName(name);
	newDefine.setNs(context.ns);
	RNInterleave interleave = new RNInterleave();
	newDefine.addElementHedge(interleave);
	int size = defines.size();
	for (int i = 0;i < size;i++) {
	    RNDefine oldDefine = (RNDefine)defines.get(i);
	    RNGroup group = new RNGroup();
	    group.setElementHedge(oldDefine.getElementHedge());
	    interleave.addElementHedge(group);
	}
	return (newDefine);
    }

    private void _adjustNs(IRNode[] children, String ns) {
	for (int i = 0;i < children.length;i++) {
	    _adjustNs(children[i], ns);
	}
    }

    private void _adjustNs(IRNode child, String ns) {
	if (child instanceof RNElement) {
	    RNElement element = (RNElement)child;
//System.out.println("element ns = " + element.getNs());
	    if (element.getNs() == null) {
		element.setNs(ns);
	    }
	    return;
	}
	_adjustNs(child.getRNodes(), ns);
    }

/*
    public List getDefines() {
	List list = new ArrayList();
	Iterator iter = names_.iterator();
	while (iter.hasNext()) {
	    String name = (String)iter.next();
	    RNDefine[] defines = (RNDefine[])defines_.get(name);
	    if (defines.length == 0) {
		throw (new InternalError());
	    } else if (defines.length == 1) {
		list.add(defines[0]);
	    } else {
		if (_isChoice(defines)) {
		    RNDefine newDefine = new RNDefine();
		    newDefine.setName(name);
		    RNChoice choice = new RNChoice();
		    newDefine.addElementHedge(choice);
		    for (int i = 0;i < defines.length;i++) {
			RNDefine oldDefine = defines[i];
			RNGroup group = new RNGroup();
			group.setElementHedge(oldDefine.getElementHedge());
			choice.addElementHedge(group);
		    }
		    list.add(newDefine);
		} else if (_isInterleave(defines)) {
		    RNDefine newDefine = new RNDefine();
		    newDefine.setName(name);
		    RNInterleave interleave = new RNInterleave();
		    newDefine.addElementHedge(interleave);
		    for (int i = 0;i < defines.length;i++) {
			RNDefine oldDefine = defines[i];
			RNGroup group = new RNGroup();
			group.setElementHedge(oldDefine.getElementHedge());
			interleave.addElementHedge(group);
		    }
		    list.add(newDefine);
		} else {
		    throw (new UnsupportedOperationException());
		}
	    }
	}
	return (list);
    }
*/

    private boolean _isChoice(List defines) {
	int size = defines.size();
	int choice = 0;
	int interleave = 0;
	for (int i = 0;i < size;i++) {
	    RNDefine define = (RNDefine)defines.get(i);
	    String combine = define.getCombine();
	    if (combine == null) {
		// do nothing
	    } else if ("choice".equals(define.getCombine())) {
		choice++;
	    } else if ("interleave".equals(define.getCombine())) {
		interleave++;
	    } else {
		throw (new RNGSyntaxErrorException("Illegal combine value = " + combine));
	    }
	}
	if (choice > 0) {
	    if (interleave > 0) {
		throw (new RNGSyntaxErrorException("Conflict choice and interleave in combine"));
	    } else {
		return (true);
	    }
	} else {
	    return (false);
	}
    }

    private boolean _isInterleave(List defines) {
	int size = defines.size();
	int choice = 0;
	int interleave = 0;
	for (int i = 0;i < size;i++) {
	    RNDefine define = (RNDefine)defines.get(i);
	    String combine = define.getCombine();
	    if (combine == null) {
		// do nothing
	    } else if ("choice".equals(define.getCombine())) {
		choice++;
	    } else if ("interleave".equals(define.getCombine())) {
		interleave++;
	    } else {
		throw (new RNGSyntaxErrorException("Illegal combine value = " + combine));
	    }
	}
	if (interleave > 0) {
	    if (choice > 0) {
		throw (new RNGSyntaxErrorException("Conflict choice and interleave in combine"));
	    } else {
		return (true);
	    }
	} else {
	    return (false);
	}
    }

/*
    private boolean _isChoice(RNDefine[] defines) {
	for (int i = 0;i < defines.length;i++) {
	    RNDefine define = defines[i];
	    if ("choice".equals(define.getCombine())) {
		return (true);
	    }
	}
	return (false);
    }

    private boolean _isInterleave(RNDefine[] defines) {
	for (int i = 0;i < defines.length;i++) {
	    RNDefine define = defines[i];
	    if ("interleave".equals(define.getCombine())) {
		return (true);
	    }
	}
	return (false);
    }
*/

    public List getStarts() {
	return (starts_);
    }

    private void _expandElement(
	RNElement element
    ) {
	RNGrammar grammar = new RNGrammar();
	String name = element.getName();
	if (name == null) {
	    name = "name";
	}
	RNDefine define = new RNDefine();
	define.setName(name);
	define.setNs(element.getNs());
	define.addElementHedge(element);
	RNRef ref = new RNRef();
	ref.setName(name);
	RNStart start = new RNStart();
	start.addElementHedge(ref);
	grammar.addGrammarContent(start);
	grammar.addGrammarContent(define);
	_expandGrammar(grammar);
    }

    private void _expandGrammar(
	RNGrammar grammar
    ) {
	_resolveNs(grammar);
	IRNGrammarContentChoice[] contents = grammar.getGrammarContent();
	for (int i = 0;i < contents.length;i++) {
	    IRNGrammarContentChoice content = contents[i];
	    if (content instanceof RNDefine) {
		RNDefine newDefine = (RNDefine)content;
//System.out.println(newDefine.getName() + "<<");
		_addEffectiveDefine(newDefine);
	    } else if (content instanceof RNInclude) {
		_includeGrammar((RNInclude)content);
	    } else if (content instanceof RNStart) {
		RNStart newStart = (RNStart)content;
		_addEffectiveStart(newStart);
	    } else if (content instanceof RNDiv) {
		_buildDiv((RNDiv)content);
//	    } else if (content instanceof RNGrammar) {
//		_embedGrammar((RNGrammar)content);
	    } else {
		throw (new RNGSyntaxErrorException("Illegal element"));
	    }
	}
    }

    private void _buildDiv(RNDiv div) {
	IRNGrammarContentChoice[] contents = div.getGrammarContent();
	for (int i = 0;i < contents.length;i++) {
	    IRNGrammarContentChoice content = contents[i];
	    if (content instanceof RNDefine) {
		RNDefine newDefine = (RNDefine)content;
		_addEffectiveDefine(newDefine);
	    } else if (content instanceof RNInclude) {
		_includeGrammar((RNInclude)content);
	    } else if (content instanceof RNStart) {
		RNStart newStart = (RNStart)content;
		_addEffectiveStart(newStart);
	    } else if (content instanceof RNDiv) {
		_buildDiv((RNDiv)content);
//	    } else if (content instanceof RNGrammar) {
//		_embedGrammar((RNGrammar)content);
	    } else {
		throw (new RNGSyntaxErrorException("Illegal element"));
	    }
	}
    }

/*
    private void _embedGrammar(RNGrammar grammar) {
	_pushContext();
	_expandGrammar(grammar);
	_popContext();
    }
*/

    private void _includeGrammar(
	RNInclude include
    ) {
	Object node = null;
	String uri = include.getHref();
	if (uri == null) {
	    throw (new RNGSyntaxErrorException("Empty uri"));
	}
	try {
//	    uri = URelaxNg.makeUri(uri, baseUri_);
	    IRelaxNgFactory factory = RelaxNgFactory.getFactory();
	    factory.rSetBaseUri(current_.baseUri);
	    factory.rSetErrorHandler(new RNGGrammarErrorHandler());
	    node = factory.create(uri);
	    _resolveNs((IRNode)node);
	} catch (IOException e) {
	    throw (URelaxNg.makeSyntaxErrorExceptionUnavailableUri(uri, e));
	} catch (SAXException e) {
	    throw (URelaxNg.makeSyntaxErrorExceptionUnavailableUri(uri, e));
	} catch (ParserConfigurationException e) {
	    throw (URelaxNg.makeSyntaxErrorExceptionUnavailableUri(uri, e));
	}
	RNDefine[] replacingDefines = _getReplacingDefines(include);
	for (int i = 0;i < replacingDefines.length;i++) {
	    _addEffectiveDefine(replacingDefines[i]);
	}
	RNStart[] replacingStarts = _getReplacingStarts(include);
	for (int i = 0;i < replacingStarts.length;i++) {
	    _addEffectiveStart(replacingStarts[i]);
	}
	_pushContext();
	current_.baseUri = _makeNewBaseUri(current_.baseUri, uri);
	current_.setReplacingDefines(replacingDefines);
	current_.setReplacingStarts(replacingStarts);
	if (node instanceof RNGrammar) {
	    _expandGrammar((RNGrammar)node);
	} else if (node instanceof RNDefine) {
	    RNDefine newDefine = (RNDefine)node;
	    _addEffectiveDefine(newDefine);
	} else if (node instanceof RNElement) {
	    throw (new UnsupportedOperationException());
	} else if (node instanceof RNDiv) {
	    _buildDiv((RNDiv)node);
	} else {
	    throw (new RNGSyntaxErrorException("Illegal element"));
	}
	_popContext();
    }

    private String _makeNewBaseUri(String baseUri, String uri) {
	try {
	    URL url = new URL(uri);
	    return (uri);
	} catch (MalformedURLException e) {
	}
//System.out.println("base = " + baseUri);
//System.out.println("container = " + newContainer);
	String newContainer = UString.getContainerPathname(uri);
	if (newContainer == null) {
	    return (baseUri);
	} else {
	    return (baseUri + "/" + newContainer);
	}
    }


    private RNDefine[] _getReplacingDefines(RNInclude include) {
	List list = new ArrayList();
	IRNIncludeContentChoice[] contents = include.getIncludeContent();
	for (int i = 0;i < contents.length;i++) {
	    IRNIncludeContentChoice content = contents[i];
	    if (content instanceof RNStart) {
		// do nothing
	    } else if (content instanceof RNDefine) {
		list.add(content);
	    } else if (content instanceof RNDiv) {
		_getReplacingDefines((RNDiv)content, list);
	    } else {
		throw (new InternalError());
	    }
	}
	RNDefine[] result = new RNDefine[list.size()];
	return ((RNDefine[])list.toArray(result));
    }

    private void _getReplacingDefines(RNDiv div, List list) {
	IRNGrammarContentChoice[] contents = div.getGrammarContent();
	for (int i = 0;i < contents.length;i++) {
	    IRNGrammarContentChoice content = contents[i];
	    if (content instanceof RNStart) {
		// do nothing
	    } else if (content instanceof RNDefine) {
		list.add(content);
	    } else if (content instanceof RNDiv) {
		_getReplacingDefines((RNDiv)content, list);
	    } else {
		// do nothing
	    }
	}
    }

    private RNStart[] _getReplacingStarts(RNInclude include) {
	List list = new ArrayList();
	IRNIncludeContentChoice[] contents = include.getIncludeContent();
	for (int i = 0;i < contents.length;i++) {
	    IRNIncludeContentChoice content = contents[i];
	    if (content instanceof RNStart) {
		list.add(content);
	    } else if (content instanceof RNDefine) {
		// do nothing
	    } else if (content instanceof RNDiv) {
		_getReplacingStarts((RNDiv)content, list);
	    } else {
		throw (new InternalError());
	    }
	}
	RNStart[] result = new RNStart[list.size()];
	return ((RNStart[])list.toArray(result));
    }

    private void _getReplacingStarts(RNDiv div, List list) {
	IRNGrammarContentChoice[] contents = div.getGrammarContent();
	for (int i = 0;i < contents.length;i++) {
	    IRNGrammarContentChoice content = contents[i];
	    if (content instanceof RNStart) {
		list.add(content);
	    } else if (content instanceof RNDefine) {
		// do nothing
	    } else if (content instanceof RNDiv) {
		_getReplacingStarts((RNDiv)content, list);
	    } else {
		// do nothing
	    }
	}
    }

    private void _addEffectiveDefine(RNDefine define) {
	Context context = current_;
	while (context != null) {
	    if (!context.isValidDefine(define)) {
		return;
	    }
	    context = context.parent;
	}
	_addDefine(define);
    }

    private void _addEffectiveStart(RNStart start) {
	Context context = current_;
	while (context != null) {
	    if (!context.isValidStart(start)) {
		return;
	    }
	    context = context.parent;
	}
	_addStart(start);
    }

    private void _addDefine(RNDefine define) {
	String name = define.getName();
//System.out.print("addDefine:");
//System.out.print("name = " + name);
//System.out.println(" ns = " + define.getNs());
	names_.add(name);
	current_.defines.add(define.getName(), define);
    }

    private void _addStart(RNStart start) {
	starts_.add(start);
    }

    private void _pushContext() {
	Context newContext = new Context();
	newContext.baseUri = current_.baseUri;
	newContext.ns = current_.ns;
	newContext.parent = current_;
	current_.children.add(newContext);
	current_ = newContext;
    }

    private void _popContext() {
	current_ = current_.parent;
    }

    private void _resolveNs(IRNode node) {
	NsResolver resolver = new NsResolver(current_.ns);
	URVisitor.traverse(node, resolver);
    }

    static class Context {
	String baseUri;
	String ns;
	List children = new ArrayList();
	RNDefine[] replacingDefines = null;
	boolean isReplaceStart = false;
	MultiValueMap defines = new MultiValueMap(
	    new RNDefine[0]
	);
	Context parent;

	public void setReplacingDefines(RNDefine[] defines) {
	    replacingDefines = defines;
	}

	public void setReplacingStarts(RNStart[] starts) {
	    if (starts != null && starts.length > 0) {
		isReplaceStart = true;
	    }
	}

	public boolean isValidDefine(RNDefine define) {
//System.out.println("valid check1 = " + define.getName());
	    if (replacingDefines == null) {
		return (true);
	    }
	    String name = define.getName();
//System.out.println("valid check2 = " + name);
	    for (int i = 0;i < replacingDefines.length;i++) {
		if (name.equals(replacingDefines[i].getName())) {
		    return (false);
		}
	    }
	    return (true);
	}

	public boolean isValidStart(RNStart start) {
	    return (!isReplaceStart);
	}
    }
}
