package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RNExcept</b> is generated from relaxNg.rxm by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="except">
 *   <tag name="except">
 *     <attribute name="datatypeLibrary" type="ngURI"/>
 *   </tag>
 *   <choice>
 *     <hedgeRef label="nameClassHedge" occurs="+"/>
 *   </choice>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="except"&gt;
 *   &lt;tag name="except"&gt;
 *     &lt;attribute name="datatypeLibrary" type="ngURI"/&gt;
 *   &lt;/tag&gt;
 *   &lt;choice&gt;
 *     &lt;hedgeRef label="nameClassHedge" occurs="+"/&gt;
 *   &lt;/choice&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxNg.rxm (Tue Dec 17 16:01:32 GMT+09:00 2002)
 * @author  Relaxer 1.0RCb (http://www.relaxer.org)
 */
public class RNExcept implements java.io.Serializable, IRNSContainer, IRVisitable, IRNode {
    private RNSContext rNSContext_ = new RNSContext(this, "http://relaxng.org/ns/structure/1.0");
    private String datatypeLibrary_;
    // List<IRNNameClassHedgeChoice>
    private java.util.List nameClassHedge_ = new java.util.ArrayList();
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>RNExcept</code>.
     *
     */
    public RNExcept() {
    }

    /**
     * Creates a <code>RNExcept</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RNExcept(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RNExcept</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RNExcept(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RNExcept</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RNExcept(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RNExcept</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNExcept(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RNExcept</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNExcept(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RNExcept</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNExcept(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RNExcept</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNExcept(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RNExcept</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNExcept(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RNExcept</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNExcept(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RNExcept</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RNExcept</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RNExcept</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        IRelaxNgFactory factory = RelaxNgFactory.getFactory();
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        datatypeLibrary_ = URelaxer.getAttributePropertyAsString(element, "datatypeLibrary");
        nameClassHedge_.clear();
        while (true) {
            if (RNNsName.isMatch(stack)) {
                addNameClassHedge(factory.createRNNsName(stack));
            } else if (RNName.isMatch(stack)) {
                addNameClassHedge(factory.createRNName(stack));
            } else if (RNAnyName.isMatch(stack)) {
                addNameClassHedge(factory.createRNAnyName(stack));
            } else if (RNNameChoice.isMatch(stack)) {
                addNameClassHedge(factory.createRNNameChoice(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "except");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.datatypeLibrary_ != null) {
            URelaxer.setAttributePropertyByString(element, "datatypeLibrary", this.datatypeLibrary_);
        }
        size = this.nameClassHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNNameClassHedgeChoice value = (IRNNameClassHedgeChoice)this.nameClassHedge_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RNExcept</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RNExcept</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNExcept</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNExcept</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNExcept</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNExcept</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>rNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext getRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>rNSContext</b>.
     *
     * @param rNSContext
     */
    public final void setRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>datatypeLibrary</b>.
     *
     * @return String
     */
    public final String getDatatypeLibrary() {
        return (datatypeLibrary_);
    }

    /**
     * Sets the String property <b>datatypeLibrary</b>.
     *
     * @param datatypeLibrary
     */
    public final void setDatatypeLibrary(String datatypeLibrary) {
        this.datatypeLibrary_ = datatypeLibrary;
    }

    /**
     * Gets the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     * @return IRNNameClassHedgeChoice[]
     */
    public final IRNNameClassHedgeChoice[] getNameClassHedge() {
        IRNNameClassHedgeChoice[] array = new IRNNameClassHedgeChoice[nameClassHedge_.size()];
        return ((IRNNameClassHedgeChoice[])nameClassHedge_.toArray(array));
    }

    /**
     * Sets the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     * @param nameClassHedge
     */
    public final void setNameClassHedge(IRNNameClassHedgeChoice[] nameClassHedge) {
        this.nameClassHedge_.clear();
        for (int i = 0;i < nameClassHedge.length;i++) {
            addNameClassHedge(nameClassHedge[i]);
        }
        for (int i = 0;i < nameClassHedge.length;i++) {
            nameClassHedge[i].setParentRNode(this);
        }
    }

    /**
     * Sets the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     * @param nameClassHedge
     */
    public final void setNameClassHedge(IRNNameClassHedgeChoice nameClassHedge) {
        this.nameClassHedge_.clear();
        addNameClassHedge(nameClassHedge);
        if (nameClassHedge != null) {
            nameClassHedge.setParentRNode(this);
        }
    }

    /**
     * Adds the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     * @param nameClassHedge
     */
    public final void addNameClassHedge(IRNNameClassHedgeChoice nameClassHedge) {
        this.nameClassHedge_.add(nameClassHedge);
        if (nameClassHedge != null) {
            nameClassHedge.setParentRNode(this);
        }
    }

    /**
     * Adds the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     * @param nameClassHedge
     */
    public final void addNameClassHedge(IRNNameClassHedgeChoice[] nameClassHedge) {
        for (int i = 0;i < nameClassHedge.length;i++) {
            addNameClassHedge(nameClassHedge[i]);
        }
        for (int i = 0;i < nameClassHedge.length;i++) {
            nameClassHedge[i].setParentRNode(this);
        }
    }

    /**
     * Gets number of the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     * @return int
     */
    public final int getNameClassHedgeCount() {
        return (nameClassHedge_.size());
    }

    /**
     * Gets the IRNNameClassHedgeChoice property <b>nameClassHedge</b> by index.
     *
     * @param index
     * @return IRNNameClassHedgeChoice
     */
    public final IRNNameClassHedgeChoice getNameClassHedge(int index) {
        return ((IRNNameClassHedgeChoice)nameClassHedge_.get(index));
    }

    /**
     * Sets the IRNNameClassHedgeChoice property <b>nameClassHedge</b> by index.
     *
     * @param index
     * @param nameClassHedge
     */
    public final void setNameClassHedge(int index, IRNNameClassHedgeChoice nameClassHedge) {
        this.nameClassHedge_.set(index, nameClassHedge);
    }

    /**
     * Adds the IRNNameClassHedgeChoice property <b>nameClassHedge</b> by index.
     *
     * @param index
     * @param nameClassHedge
     */
    public final void addNameClassHedge(int index, IRNNameClassHedgeChoice nameClassHedge) {
        this.nameClassHedge_.add(index, nameClassHedge);
    }

    /**
     * Remove the IRNNameClassHedgeChoice property <b>nameClassHedge</b> by index.
     *
     * @param index
     */
    public final void removeNameClassHedge(int index) {
        this.nameClassHedge_.remove(index);
    }

    /**
     * Remove the IRNNameClassHedgeChoice property <b>nameClassHedge</b> by object.
     *
     * @param nameClassHedge
     */
    public final void removeNameClassHedge(IRNNameClassHedgeChoice nameClassHedge) {
        this.nameClassHedge_.remove(nameClassHedge);
    }

    /**
     * Clear the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     */
    public final void clearNameClassHedge() {
        this.nameClassHedge_.clear();
    }

    /**
     * Gets the element to use object construction.
     *
     * @return Element
     */
    public Element getXMLElement() {
        return (xmlElement);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.append("<");
        URelaxer.makeQName(prefix, "except", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (datatypeLibrary_ != null) {
            buffer.append(" ");
            buffer.append("datatypeLibrary");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.append("\"");
        }
        size = this.nameClassHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNNameClassHedgeChoice value = (IRNNameClassHedgeChoice)this.nameClassHedge_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.nameClassHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNNameClassHedgeChoice value = (IRNNameClassHedgeChoice)this.nameClassHedge_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "except", buffer);
        buffer.append(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.print("<");
        URelaxer.makeQName(prefix, "except", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (datatypeLibrary_ != null) {
            buffer.print(" ");
            buffer.print("datatypeLibrary");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.print("\"");
        }
        size = this.nameClassHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNNameClassHedgeChoice value = (IRNNameClassHedgeChoice)this.nameClassHedge_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.nameClassHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNNameClassHedgeChoice value = (IRNNameClassHedgeChoice)this.nameClassHedge_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "except", buffer);
        buffer.print(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDatatypeLibraryAsString() {
        return (URelaxer.getString(getDatatypeLibrary()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDatatypeLibraryByString(String string) {
        setDatatypeLibrary(URelaxer.getString(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(nameClassHedge_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RNExcept</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://relaxng.org/ns/structure/1.0", "except")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (RNNsName.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNName.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNAnyName.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNNameChoice.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return (false);
        }
        while (true) {
            if (RNNsName.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNName.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNAnyName.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNNameChoice.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNExcept</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNExcept</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
