package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RNTextOneOrMore</b> is generated from relaxNg.rxm by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="textOneOrMore">
 *   <tag name="oneOrMore">
 *     <attribute name="datatypeLibrary" type="ngURI"/>
 *   </tag>
 *   <sequence>
 *     <hedgeRef label="textHedge" occurs="+"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="textOneOrMore"&gt;
 *   &lt;tag name="oneOrMore"&gt;
 *     &lt;attribute name="datatypeLibrary" type="ngURI"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;hedgeRef label="textHedge" occurs="+"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxNg.rxm (Tue Dec 17 16:01:32 GMT+09:00 2002)
 * @author  Relaxer 1.0RCb (http://www.relaxer.org)
 */
public class RNTextOneOrMore implements java.io.Serializable, IRNSContainer, IRVisitable, IRNode, IRNTextHedgeChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://relaxng.org/ns/structure/1.0");
    private String datatypeLibrary_;
    // List<IRNTextHedgeChoice>
    private java.util.List textHedge_ = new java.util.ArrayList();
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>RNTextOneOrMore</code>.
     *
     */
    public RNTextOneOrMore() {
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RNTextOneOrMore(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RNTextOneOrMore(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RNTextOneOrMore(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNTextOneOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNTextOneOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNTextOneOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNTextOneOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNTextOneOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNTextOneOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RNTextOneOrMore</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RNTextOneOrMore</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RNTextOneOrMore</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        IRelaxNgFactory factory = RelaxNgFactory.getFactory();
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        datatypeLibrary_ = URelaxer.getAttributePropertyAsString(element, "datatypeLibrary");
        textHedge_.clear();
        while (true) {
            if (RNData.isMatch(stack)) {
                addTextHedge(factory.createRNData(stack));
            } else if (RNValue.isMatch(stack)) {
                addTextHedge(factory.createRNValue(stack));
            } else if (RNRef.isMatch(stack)) {
                addTextHedge(factory.createRNRef(stack));
            } else if (RNList.isMatch(stack)) {
                addTextHedge(factory.createRNList(stack));
            } else if (RNTextChoice.isMatch(stack)) {
                addTextHedge(factory.createRNTextChoice(stack));
            } else if (RNTextOptional.isMatch(stack)) {
                addTextHedge(factory.createRNTextOptional(stack));
            } else if (RNTextZeroOrMore.isMatch(stack)) {
                addTextHedge(factory.createRNTextZeroOrMore(stack));
            } else if (RNText.isMatch(stack)) {
                addTextHedge(factory.createRNText(stack));
            } else if (RNNotAllowed.isMatch(stack)) {
                addTextHedge(factory.createRNNotAllowed(stack));
            } else if (RNEmpty.isMatch(stack)) {
                addTextHedge(factory.createRNEmpty(stack));
            } else if (RNTextOneOrMore.isMatch(stack)) {
                addTextHedge(factory.createRNTextOneOrMore(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "oneOrMore");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.datatypeLibrary_ != null) {
            URelaxer.setAttributePropertyByString(element, "datatypeLibrary", this.datatypeLibrary_);
        }
        size = this.textHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNTextHedgeChoice value = (IRNTextHedgeChoice)this.textHedge_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RNTextOneOrMore</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RNTextOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNTextOneOrMore</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNTextOneOrMore</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNTextOneOrMore</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNTextOneOrMore</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>rNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext getRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>rNSContext</b>.
     *
     * @param rNSContext
     */
    public final void setRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>datatypeLibrary</b>.
     *
     * @return String
     */
    public final String getDatatypeLibrary() {
        return (datatypeLibrary_);
    }

    /**
     * Sets the String property <b>datatypeLibrary</b>.
     *
     * @param datatypeLibrary
     */
    public final void setDatatypeLibrary(String datatypeLibrary) {
        this.datatypeLibrary_ = datatypeLibrary;
    }

    /**
     * Gets the IRNTextHedgeChoice property <b>textHedge</b>.
     *
     * @return IRNTextHedgeChoice[]
     */
    public final IRNTextHedgeChoice[] getTextHedge() {
        IRNTextHedgeChoice[] array = new IRNTextHedgeChoice[textHedge_.size()];
        return ((IRNTextHedgeChoice[])textHedge_.toArray(array));
    }

    /**
     * Sets the IRNTextHedgeChoice property <b>textHedge</b>.
     *
     * @param textHedge
     */
    public final void setTextHedge(IRNTextHedgeChoice[] textHedge) {
        this.textHedge_.clear();
        for (int i = 0;i < textHedge.length;i++) {
            addTextHedge(textHedge[i]);
        }
        for (int i = 0;i < textHedge.length;i++) {
            textHedge[i].setParentRNode(this);
        }
    }

    /**
     * Sets the IRNTextHedgeChoice property <b>textHedge</b>.
     *
     * @param textHedge
     */
    public final void setTextHedge(IRNTextHedgeChoice textHedge) {
        this.textHedge_.clear();
        addTextHedge(textHedge);
        if (textHedge != null) {
            textHedge.setParentRNode(this);
        }
    }

    /**
     * Adds the IRNTextHedgeChoice property <b>textHedge</b>.
     *
     * @param textHedge
     */
    public final void addTextHedge(IRNTextHedgeChoice textHedge) {
        this.textHedge_.add(textHedge);
        if (textHedge != null) {
            textHedge.setParentRNode(this);
        }
    }

    /**
     * Adds the IRNTextHedgeChoice property <b>textHedge</b>.
     *
     * @param textHedge
     */
    public final void addTextHedge(IRNTextHedgeChoice[] textHedge) {
        for (int i = 0;i < textHedge.length;i++) {
            addTextHedge(textHedge[i]);
        }
        for (int i = 0;i < textHedge.length;i++) {
            textHedge[i].setParentRNode(this);
        }
    }

    /**
     * Gets number of the IRNTextHedgeChoice property <b>textHedge</b>.
     *
     * @return int
     */
    public final int getTextHedgeCount() {
        return (textHedge_.size());
    }

    /**
     * Gets the IRNTextHedgeChoice property <b>textHedge</b> by index.
     *
     * @param index
     * @return IRNTextHedgeChoice
     */
    public final IRNTextHedgeChoice getTextHedge(int index) {
        return ((IRNTextHedgeChoice)textHedge_.get(index));
    }

    /**
     * Sets the IRNTextHedgeChoice property <b>textHedge</b> by index.
     *
     * @param index
     * @param textHedge
     */
    public final void setTextHedge(int index, IRNTextHedgeChoice textHedge) {
        this.textHedge_.set(index, textHedge);
    }

    /**
     * Adds the IRNTextHedgeChoice property <b>textHedge</b> by index.
     *
     * @param index
     * @param textHedge
     */
    public final void addTextHedge(int index, IRNTextHedgeChoice textHedge) {
        this.textHedge_.add(index, textHedge);
    }

    /**
     * Remove the IRNTextHedgeChoice property <b>textHedge</b> by index.
     *
     * @param index
     */
    public final void removeTextHedge(int index) {
        this.textHedge_.remove(index);
    }

    /**
     * Remove the IRNTextHedgeChoice property <b>textHedge</b> by object.
     *
     * @param textHedge
     */
    public final void removeTextHedge(IRNTextHedgeChoice textHedge) {
        this.textHedge_.remove(textHedge);
    }

    /**
     * Clear the IRNTextHedgeChoice property <b>textHedge</b>.
     *
     */
    public final void clearTextHedge() {
        this.textHedge_.clear();
    }

    /**
     * Gets the element to use object construction.
     *
     * @return Element
     */
    public Element getXMLElement() {
        return (xmlElement);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.append("<");
        URelaxer.makeQName(prefix, "oneOrMore", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (datatypeLibrary_ != null) {
            buffer.append(" ");
            buffer.append("datatypeLibrary");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.append("\"");
        }
        size = this.textHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNTextHedgeChoice value = (IRNTextHedgeChoice)this.textHedge_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.textHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNTextHedgeChoice value = (IRNTextHedgeChoice)this.textHedge_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "oneOrMore", buffer);
        buffer.append(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.print("<");
        URelaxer.makeQName(prefix, "oneOrMore", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (datatypeLibrary_ != null) {
            buffer.print(" ");
            buffer.print("datatypeLibrary");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.print("\"");
        }
        size = this.textHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNTextHedgeChoice value = (IRNTextHedgeChoice)this.textHedge_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.textHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNTextHedgeChoice value = (IRNTextHedgeChoice)this.textHedge_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "oneOrMore", buffer);
        buffer.print(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDatatypeLibraryAsString() {
        return (URelaxer.getString(getDatatypeLibrary()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDatatypeLibraryByString(String string) {
        setDatatypeLibrary(URelaxer.getString(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(textHedge_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RNTextOneOrMore</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://relaxng.org/ns/structure/1.0", "oneOrMore")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (RNData.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNValue.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNRef.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNList.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNTextChoice.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNTextOptional.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNTextZeroOrMore.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNText.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNNotAllowed.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNEmpty.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNTextOneOrMore.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return (false);
        }
        while (true) {
            if (RNData.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNRef.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNList.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNTextChoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNTextOptional.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNTextZeroOrMore.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNText.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNNotAllowed.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNEmpty.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNTextOneOrMore.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNTextOneOrMore</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNTextOneOrMore</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
