package org.relaxer.auth.rAccount;

import java.io.*;
import java.net.URL;
import java.sql.*;
import java.util.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AccountList extends RJDBCList {

    /**
     * Create a <code>AccountList</code>.
     *
     * @param result
     * @param st
     */
    public AccountList(ResultSet result, Statement st) {
        super(result, st);
    }

    /**
     * gets a <code>RAccount</code>.
     *
     * @param index
     * @exception SQLException
     * @return RAccount
     */
    public RAccount getRAccount(int index) throws SQLException {
        return ((RAccount)getObject(index));
    }

    /**
     * gets a <code>RAccount</code>.
     *
     * @param result
     * @exception SQLException
     * @return Object
     */
    protected Object _getObject(ResultSet result) throws SQLException {
        return (new RAccount(_getDocument(result)));
    }

    /**
     * gets a document from a ResultSet <code>rs</code>.
     *
     * @param rs
     * @exception SQLException
     * @return Document
     */
    protected Document _getDocument(ResultSet rs) throws SQLException {
        return (AccountTable.makeDocument(rs));
    }
}
