/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.util.*;
import java.io.Serializable;
import java.lang.reflect.*;
import java.sql.SQLException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.relaxer.monitor.ULog;

/**
 * AbstractRJDBCBean
 *
 * @since   Feb.  1, 2001
 * @version Jul. 23, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class AbstractRJDBCBean implements Serializable {
    private String jdbcUri_;
    private String tableName_;
    private String userName_;
    private String password_;
    private String className_;
    private String driver_;

    public void setJdbcUri(String uri) {
	jdbcUri_ = uri;
    }

    public String getJdbcUri() {
	return (jdbcUri_);
    }

    public void setTableName(String tableName) {
	tableName_ = tableName;
    }

    public void setUserName(String userName) {
	userName_ = userName;
    }

    public void setPassword(String password) {
	password_ = password;
    }

    public void setClassName(String className) {
	className_ = className;
    }

    public void setDriver(String driver) {
	driver_ = driver;
    }

    protected Object _makeHandle() throws SQLException {
	if (driver_ != null) {
	    _loadDriver(driver_);
	}
	if (userName_ != null) {
	    return (_makeHandleByUser());
	} else {
	    return (_makeHandleByDefaultUser());
	}
    }

    protected Object _makeHandleByUser() throws SQLException {
	try {
	    Class hClass = Class.forName(className_);
	    Class[] types = {
		String.class,
		String.class,
		String.class,
		String.class
	    };
	    Constructor constructor = hClass.getConstructor(types);
	    Object[] params = { jdbcUri_, tableName_, userName_, password_ };
	    return (constructor.newInstance(params));
	} catch (ClassNotFoundException e) {
	    throw (_makeSQLException(e));
	} catch (InstantiationException e) {
	    throw (_makeSQLException(e));
	} catch (IllegalAccessException e) {
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
	    throw (_makeSQLException(e));
	} 
    }

    protected Object _makeHandleByDefaultUser() throws SQLException {
	try {
	    Class hClass = Class.forName(className_);
	    Class[] types = {
		String.class,
		String.class
	    };
	    Constructor constructor = hClass.getConstructor(types);
	    Object[] params = { jdbcUri_, tableName_ };
	    return (constructor.newInstance(params));
	} catch (ClassNotFoundException e) {
	    throw (_makeSQLException(e));
	} catch (InstantiationException e) {
	    throw (_makeSQLException(e));
	} catch (IllegalAccessException e) {
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
	    throw (_makeSQLException(e));
	} 
    }

    protected void _closeHandle(
	Object handle
    ) throws SQLException {
	try {
	    Class[] types = new Class[0];
	    Method method = handle.getClass().getMethod("close", types);
	    Object[] params = new Object[0];
	    method.invoke(handle, params);
	} catch (IllegalAccessException e) {
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
	    throw (_makeSQLException(e));
	} 
    }

    private void _loadDriver(String driver) throws SQLException {
	try {
	    Class.forName(driver);
	} catch (ClassNotFoundException e) {
	    throw (_makeSQLException(e));
	}
    }

    protected final SQLException _makeSQLException(Throwable e) {
	return (ULog.makeSQLException(e));
    }
}
