/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.util.*;
import java.io.Serializable;
import java.lang.reflect.*;
import java.sql.SQLException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

/**
 * RJDBCCreateBean
 *
 * @since   Jul.  9, 2001
 * @version Apr. 19, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class RJDBCCreateBean extends AbstractRJDBCBean {
    public void createTable() throws SQLException {
	Object handle = _makeHandle();
	_createTable(handle);
	_closeHandle(handle);
    }

    public void dropCreateTable() throws SQLException {
	Object handle = _makeHandle();
	_dropTable(handle);
	_createTable(handle);
	_closeHandle(handle);
    }

    private void _createTable(
	Object handle
    ) throws SQLException {
	try {
	    Class[] types = {};
	    Method method = handle.getClass().getMethod("createTable", types);
	    Object[] params = {};
	    method.invoke(handle, params);
	} catch (IllegalAccessException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} 
    }

    private void _dropTable(
	Object handle
    ) {
	try {
	    Class[] types = {};
	    Method method = handle.getClass().getMethod("dropTable", types);
	    Object[] params = {};
	    method.invoke(handle, params);
	} catch (IllegalAccessException e) {
	} catch (NoSuchMethodException e) {
	} catch (InvocationTargetException e) {
	} 
    }
}
