/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.dialog;

import org.w3c.dom.Document;
import org.relaxer.util.URelaxer;

/**
 * AbstractDialogSlot
 *
 * @since   Jul.  4, 2001
 * @version Jul. 15, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class AbstractDialogSlot implements IDialogSlot {
    private IDialogSpace space_;
    private final String name_;
    private final Class type_;

    protected AbstractDialogSlot(String name) {
	name_ = name;
	type_ = null;
    }

    protected AbstractDialogSlot(String name, Class type) {
	name_ = name;
	type_ = type;
    }

    protected AbstractDialogSlot(
	String name,
	String className
    ) throws ClassNotFoundException {
	name_ = name;
	if (className != null) {
	    type_ = Class.forName(className);
	} else {
	    type_ = null;
	}
    }

    public final void setDialogSpace(IDialogSpace space) {
	space_ = space;
    }

    public final String getName() {
	return (name_);
    }

    public final Class getType() {
	return (type_);
    }

    protected final boolean _isRelaxerType() {
	return (URelaxer.isRelaxerType(type_));
    }

    protected final Object _makeRelaxerObject(Document doc) {
	return (URelaxer.makeRelaxerObject(type_, doc));
    }

    protected final Document _makeRelaxerDocument(Object value) {
	return (URelaxer.makeRelaxerDocument(value));
    }

    public final String resolve(String uri) {
	return (space_.resolve(uri));
    }
}
