package org.relaxer.dialog.rDialog;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>DGenericMethod</b> is generated from dialog.rngby Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="method">
 *   <attribute name="name">
 *     <data type="token"/>
 *   </attribute>
 *   <zeroOrMore>
 *     <ref name="genericParam"/>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="method"&gt;
 *   &lt;attribute name="name"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="genericParam"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version dialog.rng (Sun Oct 13 15:45:23 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class DGenericMethod implements java.io.Serializable, IREvaluatable, IRNode {
    private String name_;
    // List<DGenericParam>
    private java.util.List genericParam_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>DGenericMethod</code>.
     *
     */
    public DGenericMethod() {
    }

    /**
     * Creates a <code>DGenericMethod</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public DGenericMethod(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public DGenericMethod(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>DGenericMethod</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public DGenericMethod(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DGenericMethod(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>DGenericMethod</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DGenericMethod(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DGenericMethod(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DGenericMethod(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DGenericMethod(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DGenericMethod(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>DGenericMethod</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>DGenericMethod</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>DGenericMethod</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IDialogFactory factory = DialogFactory.getFactory();
        RStack stack = new RStack(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        genericParam_.clear();
        while (!stack.isEmptyElement()) {
            if (DGenericParam.isMatch(stack)) {
                addGenericParam(factory.createDGenericParam(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("method");
        int size;
        URelaxer.setAttributePropertyByString(element, "name", this.name_);
        size = this.genericParam_.size();
        for (int i = 0;i < size;i++) {
            DGenericParam value = (DGenericParam)this.genericParam_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>DGenericMethod</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>DGenericMethod</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DGenericMethod</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DGenericMethod</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DGenericMethod</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DGenericMethod</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the DGenericParam property <b>genericParam</b>.
     *
     * @return DGenericParam[]
     */
    public final DGenericParam[] getGenericParam() {
        DGenericParam[] array = new DGenericParam[genericParam_.size()];
        return ((DGenericParam[])genericParam_.toArray(array));
    }

    /**
     * Sets the DGenericParam property <b>genericParam</b>.
     *
     * @param genericParam
     */
    public final void setGenericParam(DGenericParam[] genericParam) {
        this.genericParam_.clear();
        for (int i = 0;i < genericParam.length;i++) {
            addGenericParam(genericParam[i]);
        }
        for (int i = 0;i < genericParam.length;i++) {
            genericParam[i].setParentRNode(this);
        }
    }

    /**
     * Sets the DGenericParam property <b>genericParam</b>.
     *
     * @param genericParam
     */
    public final void setGenericParam(DGenericParam genericParam) {
        this.genericParam_.clear();
        addGenericParam(genericParam);
        if (genericParam != null) {
            genericParam.setParentRNode(this);
        }
    }

    /**
     * Adds the DGenericParam property <b>genericParam</b>.
     *
     * @param genericParam
     */
    public final void addGenericParam(DGenericParam genericParam) {
        this.genericParam_.add(genericParam);
        if (genericParam != null) {
            genericParam.setParentRNode(this);
        }
    }

    /**
     * Gets number of the DGenericParam property <b>genericParam</b>.
     *
     * @return int
     */
    public final int getGenericParamCount() {
        return (genericParam_.size());
    }

    /**
     * Gets the DGenericParam property <b>genericParam</b> by index.
     *
     * @param index
     * @return DGenericParam
     */
    public final DGenericParam getGenericParam(int index) {
        return ((DGenericParam)genericParam_.get(index));
    }

    /**
     * Sets the DGenericParam property <b>genericParam</b> by index.
     *
     * @param index
     * @param genericParam
     */
    public final void setGenericParam(int index, DGenericParam genericParam) {
        this.genericParam_.set(index, genericParam);
    }

    /**
     * Adds the DGenericParam property <b>genericParam</b> by index.
     *
     * @param index
     * @param genericParam
     */
    public final void addGenericParam(int index, DGenericParam genericParam) {
        this.genericParam_.add(index, genericParam);
    }

    /**
     * Remove the DGenericParam property <b>genericParam</b> by index.
     *
     * @param index
     */
    public final void removeGenericParam(int index) {
        this.genericParam_.remove(index);
    }

    /**
     * Remove the DGenericParam property <b>genericParam</b> by object.
     *
     * @param genericParam
     */
    public final void removeGenericParam(DGenericParam genericParam) {
        this.genericParam_.remove(genericParam);
    }

    /**
     * Clear the DGenericParam property <b>genericParam</b>.
     *
     */
    public final void clearGenericParam() {
        this.genericParam_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<method");
        buffer.append(" name=\"");
        buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
        buffer.append("\"");
        buffer.append(">");
        size = this.genericParam_.size();
        for (int i = 0;i < size;i++) {
            DGenericParam value = (DGenericParam)this.genericParam_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</method>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<method");
        buffer.print(" name=\"");
        buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
        buffer.print("\"");
        buffer.print(">");
        size = this.genericParam_.size();
        for (int i = 0;i < size;i++) {
            DGenericParam value = (DGenericParam)this.genericParam_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</method>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setGenericParamByString(String string) throws IOException, SAXException, ParserConfigurationException {
        setGenericParam(new DGenericParam(string));
    }

    /**
     * Adds the property value by String.
     *
     * @param string
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void addGenericParamByString(String string) throws IOException, SAXException, ParserConfigurationException {
        addGenericParam(new DGenericParam(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Evaluates the node.
     *
     * @return Object
     */
    public Object eval() {
        return (eval(new RSimpleEvaluationContext()));
    }

    /**
     * Evaluates the node with the evaluation context.
     *
     * @param context
     * @return Object
     */
    public Object eval(IREvaluationContext context) {
        IRNode[] children = getRNodes();
        Object[] params = new Object[children.length];
        for (int i = 0;i < children.length;i++) {
            IRNode child = children[i];
            if (child instanceof IREvaluatable) {
                params[i] = ((IREvaluatable)child).eval(context);
            } else {
                params[i] = child;
            }
        }
        return (eval(params, context));
    }

    /**
     * Evaluates against the params.
     *
     * @param params
     * @param context
     * @return Object
     */
    public Object eval(Object[] params, IREvaluationContext context) {
        if (params == null) {
            return (null);
        }
        if (params.length == 0) {
            return (null);
        }
        return (params[params.length -1]);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(genericParam_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>DGenericMethod</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "method")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!target.hasAttributeHungry("name")) {
            return (false);
        }
        $match$ = true;
        while (!target.isEmptyElement()) {
            if (!DGenericParam.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DGenericMethod</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DGenericMethod</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
