package org.relaxer.dialog.rDialog;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>DSlot</b> is generated from dialog.rngby Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="slot">
 *   <attribute name="name">
 *     <data type="token"/>
 *   </attribute>
 *   <optional>
 *     <attribute name="javaClass">
 *       <data type="token"/>
 *     </attribute>
 *   </optional>
 *   <optional>
 *     <choice>
 *       <ref name="read"/>
 *       <ref name="write"/>
 *       <ref name="readWrite"/>
 *       <ref name="readAndWrite"/>
 *     </choice>
 *   </optional>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="slot"&gt;
 *   &lt;attribute name="name"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;optional&gt;
 *     &lt;attribute name="javaClass"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/attribute&gt;
 *   &lt;/optional&gt;
 *   &lt;optional&gt;
 *     &lt;choice&gt;
 *       &lt;ref name="read"/&gt;
 *       &lt;ref name="write"/&gt;
 *       &lt;ref name="readWrite"/&gt;
 *       &lt;ref name="readAndWrite"/&gt;
 *     &lt;/choice&gt;
 *   &lt;/optional&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version dialog.rng (Sun Oct 13 15:45:23 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class DSlot implements java.io.Serializable, IREvaluatable, IRNode {
    private String name_;
    private String javaClass_;
    private IDSlotChoice content_;
    private IRNode parentRNode_;

    /**
     * Creates a <code>DSlot</code>.
     *
     */
    public DSlot() {
    }

    /**
     * Creates a <code>DSlot</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public DSlot(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>DSlot</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public DSlot(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>DSlot</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public DSlot(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>DSlot</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DSlot(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>DSlot</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DSlot(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>DSlot</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DSlot(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>DSlot</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DSlot(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>DSlot</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DSlot(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>DSlot</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DSlot(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>DSlot</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>DSlot</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>DSlot</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IDialogFactory factory = DialogFactory.getFactory();
        RStack stack = new RStack(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        javaClass_ = URelaxer.getAttributePropertyAsString(element, "javaClass");
        if (DReadAndWrite.isMatch(stack)) {
            setContent(factory.createDReadAndWrite(stack));
        } else if (DRead.isMatch(stack)) {
            setContent(factory.createDRead(stack));
        } else if (DWrite.isMatch(stack)) {
            setContent(factory.createDWrite(stack));
        } else if (DReadWrite.isMatch(stack)) {
            setContent(factory.createDReadWrite(stack));
        } else {
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("slot");
        int size;
        URelaxer.setAttributePropertyByString(element, "name", this.name_);
        if (this.javaClass_ != null) {
            URelaxer.setAttributePropertyByString(element, "javaClass", this.javaClass_);
        }
        if (this.content_ != null) {
            this.content_.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>DSlot</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>DSlot</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DSlot</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DSlot</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DSlot</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DSlot</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>javaClass</b>.
     *
     * @return String
     */
    public final String getJavaClass() {
        return (javaClass_);
    }

    /**
     * Sets the String property <b>javaClass</b>.
     *
     * @param javaClass
     */
    public final void setJavaClass(String javaClass) {
        this.javaClass_ = javaClass;
    }

    /**
     * Gets the IDSlotChoice property <b>content</b>.
     *
     * @return IDSlotChoice
     */
    public final IDSlotChoice getContent() {
        return (content_);
    }

    /**
     * Sets the IDSlotChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IDSlotChoice content) {
        this.content_ = content;
        if (content != null) {
            content.setParentRNode(this);
        }
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<slot");
        buffer.append(" name=\"");
        buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
        buffer.append("\"");
        if (javaClass_ != null) {
            buffer.append(" javaClass=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getJavaClass())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (content_ != null) {
            content_.makeTextElement(buffer);
        }
        buffer.append("</slot>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<slot");
        buffer.print(" name=\"");
        buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
        buffer.print("\"");
        if (javaClass_ != null) {
            buffer.print(" javaClass=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getJavaClass())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (content_ != null) {
            content_.makeTextElement(buffer);
        }
        buffer.print("</slot>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getJavaClassAsString() {
        return (URelaxer.getString(getJavaClass()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setJavaClassByString(String string) {
        setJavaClass(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Evaluates the node.
     *
     * @return Object
     */
    public Object eval() {
        return (eval(new RSimpleEvaluationContext()));
    }

    /**
     * Evaluates the node with the evaluation context.
     *
     * @param context
     * @return Object
     */
    public Object eval(IREvaluationContext context) {
        IRNode[] children = getRNodes();
        Object[] params = new Object[children.length];
        for (int i = 0;i < children.length;i++) {
            IRNode child = children[i];
            if (child instanceof IREvaluatable) {
                params[i] = ((IREvaluatable)child).eval(context);
            } else {
                params[i] = child;
            }
        }
        return (eval(params, context));
    }

    /**
     * Evaluates against the params.
     *
     * @param params
     * @param context
     * @return Object
     */
    public Object eval(Object[] params, IREvaluationContext context) {
        if (params == null) {
            return (null);
        }
        if (params.length == 0) {
            return (null);
        }
        return (params[params.length -1]);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        if (content_ != null) {
            classNodes.add(content_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>DSlot</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "slot")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!target.hasAttributeHungry("name")) {
            return (false);
        }
        $match$ = true;
        if (DReadAndWrite.isMatchHungry(target)) {
            $match$ = true;
        } else if (DRead.isMatchHungry(target)) {
            $match$ = true;
        } else if (DWrite.isMatchHungry(target)) {
            $match$ = true;
        } else if (DReadWrite.isMatchHungry(target)) {
            $match$ = true;
        } else {
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DSlot</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DSlot</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
