/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.goldenport;

import java.util.*;
import org.w3c.dom.*;

/**
 * PortContext
 *
 * @since   Feb.  9, 2002
 * @version Jul.  8, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class PortContext {
    private PortEngine engine_;
    private IPort port_;
    private Stack stack_ = new Stack();
    private Map properties_ = new HashMap();

    public final void setEngine(PortEngine engine) {
	engine_ = engine;
    }

    public final PortEngine getEngine() {
	return (engine_);
    }

    public final void setPort(IPort port) {
	port_ = port;
    }

    public final IPort getPort() {
	return (port_);
    }

    public final void pushElement(Element element) {
	stack_.push(element);
    }

    public final Element popElement() {
	return ((Element)stack_.pop());
    }

    public final Element peekElement() {
	return ((Element)stack_.peek());
    }

    public final void setProperty(String key, Object value) {
	properties_.put(key, value);
    }

    public final Object getProperty(String key) {
	return (properties_.get(key));
    }
}
