/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.goldenport.ports;

import java.util.*;
import org.w3c.dom.*;
import org.relaxer.goldenport.*;
import org.relaxer.goldenport.selecter.*;

/**
 * FilterPort
 *
 * @since   Jul.  7, 2002
 * @version Jul.  8, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class FilterPort extends AbstractPort {
    private List patterns_ = new ArrayList();

    public FilterPort() {
	_setup(new AllSelecter());
    }

    public int startElement(
	Element element,
	PortContext context,
	PortNodeList result
    ) {
	int size = patterns_.size();
	for (int i = 0;i < size;i++) {
	    Pattern pattern = (Pattern)patterns_.get(i);
	    switch (pattern.eval(element)) {

	    case Pattern.SKIP:
		// do nothing
		break;
	    case Pattern.ACCEPT:
		result.setup(element);
		return (EVAL_CHILDREN);
	    case Pattern.REJECT:
		return (EVAL_DONE);
	    default:
		throw (new InternalError());
	    }
	}
	result.setup(element);
	return (EVAL_CHILDREN);
    }

    public void addPattern(
	ISelecter selecter,
	String attrName,
	String value
    ) {
	Pattern pattern = new Pattern(selecter, attrName, value);
	patterns_.add(pattern);
    }

    public void addPattern(
	ISelecter selecter,
	String attrNs,
	String attrName,
	String value
    ) {
	Pattern pattern = new Pattern(selecter, attrNs, attrName, value);
	patterns_.add(pattern);
    }

    class Pattern {
	public static final int SKIP = 1;
	public static final int ACCEPT = 2;
	public static final int REJECT = 3;

	private ISelecter selecter_;
	private String attrNs_ = null;
	private String attrName_;
	private String value_;

	public Pattern(ISelecter selecter, String attrName, String value) {
	    selecter_ = selecter;
	    attrName_ = attrName;
	    value_ = value;
	}

	public Pattern(
	    ISelecter selecter,
	    String attrNs,
	    String attrName,
	    String value
	) {
	    selecter_ = selecter;
	    attrNs_ = attrNs;
	    attrName_ = attrName;
	    value_ = value;
	}

	public int eval(Element element) {
	    if (!selecter_.isMatch(element)) {
		return (SKIP);
	    }
	    Attr attr;
	    if (attrNs_ != null) {
		attr = element.getAttributeNodeNS(attrNs_, attrName_);
	    } else {
		attr = element.getAttributeNode(attrName_);
	    }
	    if (attr == null) {
		return (ACCEPT);
	    }
	    if (attr.getValue().equals(value_)) { // XXX : tokens
		return (ACCEPT);
	    } else {
		return (REJECT);
	    }
	}
    }
}
