/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.mom;

import java.io.IOException;
import javax.jms.*;
import org.w3c.dom.Document;
import org.relaxer.xml.UDOM;

/**
 * AbstractJmsFacade
 *
 * @since   Jul. 17, 2001
 * @version Jul. 17, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class AbstractJmsFacade implements IMOMFacade {
    public Document readDocument() throws JMSException {
	Message message = read();
	if (message instanceof BytesMessage) {
	    return (_readBytesMessage((BytesMessage)message));
	} else if (message instanceof MapMessage) {
	    return (_readMapMessage((MapMessage)message));
	} else if (message instanceof ObjectMessage) {
	    return (_readObjectMessage((ObjectMessage)message));
	} else if (message instanceof StreamMessage) {
	    return (_readStreamMessage((StreamMessage)message));
	} else if (message instanceof TextMessage) {
	    return (_readTextMessage((TextMessage)message));
	} else {
	    throw (new JMSException("unknown message type = " + message));
	}
    }

    private Document _readBytesMessage(BytesMessage message)
	throws JMSException {

	throw (new UnsupportedOperationException());
    }

    private Document _readMapMessage(MapMessage message)
	throws JMSException {

	throw (new UnsupportedOperationException());
    }

    private Document _readObjectMessage(ObjectMessage message)
	throws JMSException {

	throw (new UnsupportedOperationException());
    }

    private Document _readStreamMessage(StreamMessage message)
	throws JMSException {

	throw (new UnsupportedOperationException());
    }

    private Document _readTextMessage(TextMessage message)
	throws JMSException {

	throw (new UnsupportedOperationException());
    }

    public void writeDocument(Document doc) throws JMSException {
	TextMessage message = _getSession().createTextMessage();
	message.setText(UDOM.makeTextDocument(doc));
    }

    protected abstract Session _getSession();
}
