/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.runtime;

import java.util.*;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.relaxer.auth.RAuthManager;
import org.relaxer.runtime.rFactory.*;
import org.relaxer.runtime.rRuntime.*;
import org.relaxer.runtime.logger.*;

/**
 * RComponentContext
 *
 * @since   Mar. 17, 2002
 * @version Sep.  8, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class RComponentContext {
    private List loggers_ = new ArrayList(); // List<IRComponentLogger>
    private RComponentFactory factory_;
//    private ThreadLocal runtimeContext_ = new ThreadLocal();
    private RRuntimeContext runtimeContext_;

    public RComponentContext(String uri)
	throws IOException, SAXException, ParserConfigurationException {

	System.out.println("RComponentContext");
	FConfig config = new FConfig(uri);
	_init(config);
    }

    protected RComponentContext(RComponentFactory factory) {
	System.out.println("RComponentContext2");
	_init(factory);
    }

    protected RComponentContext() {
	System.out.println("RComponentContext3");
    }

    private void _init(FConfig config) throws IOException {
	FLog[] logs = config.getLog();
	_init(logs);
	FFactory factory = config.getFactory();
	_init(new RComponentFactory(factory));
    }

    private void _init(FLog[] logs) {
	for (int i = 0;i < logs.length;i++) {
	    _init(logs[i]);
	}
    }

    private void _init(FLog log) {
	Properties properties = _makeProperties(log.getProperty());
	IFLogChoice content = log.getContent();
	if (content instanceof FLogType) {
	    _init((FLogType)content, properties);
	} else if (content instanceof FLogClassName) {
	    _init((FLogClassName)content, properties);
	} else {
	    throw (new InternalError(content.toString()));
	}
    }

    private void _init(FLogType type, Properties properties) {
	String typeName = type.getContent();
	if ("stdout".equals(typeName)) {
	    IRComponentLogger logger = new StdoutLogger();
	    logger.setup(properties);
	    loggers_.add(logger);
	} else if ("file".equals(typeName)) {
	    IRComponentLogger logger = new FileLogger();
	    logger.setup(properties);
	    loggers_.add(logger);
	}
    }

    private void _init(FLogClassName className, Properties properties) {
	try {
	    String name = className.getContent();
	    Class clazz = Class.forName(name);
	    IRComponentLogger logger = (IRComponentLogger)clazz.newInstance();
	    logger.setup(properties);
	    loggers_.add(logger);
	} catch (ClassNotFoundException e) {
	    // XXX
	} catch (InstantiationException e) {
	    // XXX
	} catch (IllegalAccessException e) {
	    // XXX
	}
    }

    private void _init(RComponentFactory factory) {
	factory_ = factory;
    }

    private Properties _makeProperties(FProperty[] fps) {
	Properties properties = new Properties();
	for (int i = 0;i < fps.length;i++) {
	    FProperty fp = fps[i];
	    properties.put(fp.getName(), fp.getValue());
	}
	return (properties);
    }

    //
    public void log(String message) {
	synchronized (this) {
	    int size = loggers_.size();
	    for (int i = 0;i < size;i++) {
		IRComponentLogger logger = (IRComponentLogger)loggers_.get(i);
		logger.log(message);
	    }
	}
    }

    public void logEnter(Object object, String name) {
	synchronized (this) {
	    int size = loggers_.size();
	    for (int i = 0;i < size;i++) {
		IRComponentLogger logger = (IRComponentLogger)loggers_.get(i);
		logger.logEnter(object, name);
	    }
	}
    }

    public void logEnter(Object object, String name, String arg) {
	synchronized (this) {
	    int size = loggers_.size();
	    for (int i = 0;i < size;i++) {
		IRComponentLogger logger = (IRComponentLogger)loggers_.get(i);
		logger.logEnter(object, name, arg);
	    }
	}
    }

    public void logEnter(
	Object object,
	String name,
	String arg1,
	String arg2
    ) {
	synchronized (this) {
	    int size = loggers_.size();
	    for (int i = 0;i < size;i++) {
		IRComponentLogger logger = (IRComponentLogger)loggers_.get(i);
		logger.logEnter(object, name, arg1, arg2);
	    }
	}
    }

    public void logEnter(
	Object object,
	String name,
	String arg1,
	String arg2,
	String arg3
    ) {
	synchronized (this) {
	    int size = loggers_.size();
	    for (int i = 0;i < size;i++) {
		IRComponentLogger logger = (IRComponentLogger)loggers_.get(i);
		logger.logEnter(object, name, arg1, arg2, arg3);
	    }
	}
    }

    public void logEnter(Object object, String name, String[] args) {
	synchronized (this) {
	    int size = loggers_.size();
	    for (int i = 0;i < size;i++) {
		IRComponentLogger logger = (IRComponentLogger)loggers_.get(i);
		logger.logEnter(object, name, args);
	    }
	}
    }

    public void logLeave(Object object, String name) {
	synchronized (this) {
	    int size = loggers_.size();
	    for (int i = 0;i < size;i++) {
		IRComponentLogger logger = (IRComponentLogger)loggers_.get(i);
		logger.logLeave(object, name);
	    }
	}
    }

    public void logLeave(Object object, String name, String result) {
	synchronized (this) {
	    int size = loggers_.size();
	    for (int i = 0;i < size;i++) {
		IRComponentLogger logger = (IRComponentLogger)loggers_.get(i);
		logger.logLeave(object, name, result);
	    }
	}
    }

    public void logLeave(Object object, String name, Exception e) {
	synchronized (this) {
	    int size = loggers_.size();
	    for (int i = 0;i < size;i++) {
		IRComponentLogger logger = (IRComponentLogger)loggers_.get(i);
		logger.logLeave(object, name, e);
	    }
	}
    }

    public Object getComponent(String id) throws RemoteException {
	synchronized (this) {
	    Object component = factory_.getComponent(id);
	    if (component instanceof IRComponentAtom) {
		((IRComponentAtom)component).rSetContext(this);
	    }
	    return (component);
	}
    }

    public Object getDao(String id) throws RemoteException {
	synchronized (this) {
	    Object dao = factory_.getDao(id);
	    if (dao instanceof IRComponentAtom) {
		((IRComponentAtom)dao).rSetContext(this);
	    }
	    return (dao);
	}
    }

    public Object getProvider(String id) throws RemoteException {
	synchronized (this) {
	    Object provider = factory_.getProvider(id);
	    if (provider instanceof IRComponentAtom) {
		((IRComponentAtom)provider).rSetContext(this);
	    }
	    return (provider);
	}
    }

    public void setRuntimeContext(String uri)
	throws IOException, SAXException, ParserConfigurationException {

	RRRuntime rrRuntime = new RRRuntime(uri);
	RRuntimeContext rrContext = new RRuntimeContext(rrRuntime);
	setRuntimeContext(rrContext);
    }

    public void setRuntimeContext(RRuntimeContext rrContext) {
//	runtimeContext_.set(rrContext);
	runtimeContext_ = rrContext;
System.out.println("setRuntimeContext");
	if (factory_ != null) {
System.out.println("setRuntimeContext2");
	    RAuthManager auth = factory_.getAuthManager();
	    if (auth != null) {
System.out.println("setRuntimeContext3");
		rrContext.authenticate(auth);
	    }
	}
    }

    public RRuntimeContext getRuntimeContext() {
//	return ((RRuntimeContext)runtimeContext_.get());
	return (runtimeContext_);
    }

    public Object getAppPrincipal() {
	RRuntimeContext rContext = getRuntimeContext();
	if (rContext == null) {
	    return (null);
	}
	return (rContext.getAppPrincipal());
    }

    public Object getAppSession() {
	RRuntimeContext rContext = getRuntimeContext();
	if (rContext == null) {
	    return (null);
	}
	return (rContext.getAppSession());
    }

    //
    public static Map contexts__ = new HashMap();
    public static RComponentContext defaultContext__;

    public static void setContext(RComponentContext context) {
	defaultContext__ = context;
    }

    public static RComponentContext getContext() {
	try {
	    if (defaultContext__ != null) {
		return (defaultContext__);
	    }
	    URL url = RComponentContext.class.getResource(
		"/META-INF/relaxer-config.xml"
	    );
	    if (url == null) {
		url = RComponentContext.class.getResource(
		    "/WEB-INF/relaxer-config.xml"
		);
		if (url == null) {
		    defaultContext__ = new RComponentContext();
		    return (defaultContext__);
		}
	    }
	    defaultContext__ = getContext(url);
	    return (defaultContext__);
	} catch (IOException e) {
	    throw (new InternalError());
	} catch (SAXException e) {
	    throw (new InternalError());
	} catch (ParserConfigurationException e) {
	    throw (new InternalError());
	}
    }

    public static RComponentContext getContext(String uri)
	throws IOException, SAXException, ParserConfigurationException {

	// XXX : default context problem - context id management
	RComponentContext context = (RComponentContext)contexts__.get(uri);
	if (context == null) {
	    context = new RComponentContext(uri);
	    contexts__.put(uri, context);
	}
	return (context);
    }

    public static RComponentContext getContext(URL url)
	throws IOException, SAXException, ParserConfigurationException {

	return (getContext(url.toExternalForm()));
    }

    public static RComponentContext getContext(Object object) {
	return (getContext(object.getClass()));	// XXX
    }

    public static RComponentContext getContext(Class clazz) {
        try {
	    // XXX : security manager problem -> tips
System.out.println("class = " + clazz);
            URL url = clazz.getResource("/META-INF/relaxer-config.xml");
System.out.println("getContext = " + url);
            if (url != null) {
		RComponentContext context = getContext(url);
		if (context != null) {
		    return (context);
		}
            };
        } catch (IOException e) {
        } catch (SAXException e) {
        } catch (ParserConfigurationException e) {
        }
	return (RComponentContext.getContext());
    }

    public static String fetchContext(Object object) {
System.out.println("fetchContext");
	RComponentContext cContext = RComponentContext.getContext(object);
	if (cContext == null) {
	    return (null);
	}
System.out.println("fetchContext2");
	RRuntimeContext rContext = cContext.getRuntimeContext();
	if (rContext == null) {
	    return (null);
	}
System.out.println("fetchContext3");
	return (rContext.getXml());
    }

    public static void storeContext(String context, Object object)
	throws IOException, SAXException, ParserConfigurationException {

System.out.println("storeContext");
	if (context == null) {
	    return;
	}
	RComponentContext cContext = RComponentContext.getContext(object);
System.out.println("storeContext2");
	if (cContext == null) {
	    return;
	}
System.out.println("storeContext3");
	RRuntimeContext rContext = new RRuntimeContext(context);
System.out.println("storeContext4");
	cContext.setRuntimeContext(rContext);
System.out.println("storeContext5");
    }
}
