/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import javax.xml.parsers.*;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.relaxer.util.D2Array;

/**
 * AbstractMutableTabular
 *
 * @since   Aug. 13, 2001
 * @version Aug. 13, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class AbstractMutableTabular extends AbstractTabular
    implements IMutableTabular {

    public final void setName(String name) {
	_setName(name);
    }

    public final void set(Document doc) {
	clearData();
	add(doc);
    }

    public final void set(Element element) {
	clearData();
	add(element);
    }

    public final void add(Document doc) {
	add(doc.getDocumentElement());
    }

    public final void add(Element element) {
	String[] labels = UHTML.table2Labels(element);
	D2Array data = UHTML.table2Array(element);
	for (int x = 0;x < labels.length;x++) {
	    setLabel(x, labels[x]);
	}
	int width = data.getWidth();
	int height = data.getHeight();
	int containerHeight = getHeight();
	for (int y = 0;y < height;y++) {
	    for (int x = 0;x < width;x++) {
		set(x, y + containerHeight, data.get(x, y));
	    }
	}
    }
}
