/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.util.*;
import java.lang.reflect.*;
import java.rmi.RemoteException;
import javax.servlet.jsp.*;
import javax.rmi.*;
import javax.ejb.*;
import javax.naming.*;
import org.relaxer.util.RObjectSlot;
import org.relaxer.beans.EJBSessionBean;
import com.AsamiOffice.text.UString;

/**
 * EJBSessionBeanTag
 *
 * @since   Sep. 16, 2001
 * @version Feb. 25, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class EJBSessionBeanTag extends AbstractRelaxerTag {
    private EJBSessionBean bean_ = new EJBSessionBean();
    private String method_;
    private String[] params_;

    public void setUri(String uri) {
	bean_.setUri(uri);
    }

    public void setProxy(String name) {
	bean_.setProxyName(name);
    }

    public void setMethod(String method) {
	method_ = method;
    }

    public void setParams(String params) {
	params_ = UString.makeStringList(params);
    }

    protected Object _doEvaluate(RObjectSlot[] params)
	throws JspTagException {

	try {
	    return (bean_.invoke(method_, params_));
	} catch (RemoteException e) {
	    throw (_makeJspTagException(e));
	} catch (NamingException e) {
	    throw (_makeJspTagException(e));
	} catch (CreateException e) {
	    throw (_makeJspTagException(e));
	} catch (IllegalAccessException e) {
	    throw (_makeJspTagException(e));
	} catch (IllegalArgumentException e) {
	    throw (_makeJspTagException(e));
	} catch (InvocationTargetException e) {
	    throw (_makeJspTagException(e));
	} catch (NoSuchMethodException e) {
	    throw (_makeJspTagException(e));
	} catch (InstantiationException e) {
	    throw (_makeJspTagException(e));
	} catch (ClassNotFoundException e) {
	    throw (_makeJspTagException(e));
	}
    }
}
