/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc;

import java.util.*;
import java.io.*;
import java.net.URL;
import java.net.MalformedURLException;
import jp.gr.java_conf.jaba2.j2fw.J2Monitor;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.j2fw.generator.*;

/**
 * AbstractSmartDocGenerator
 *
 * @since   Nov.  7, 1998
 * @version Aug. 10, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class AbstractSmartDocGenerator
    extends AbstractGenerator implements SmartDocGenerator {

    protected J2Monitor monitor_;
    protected SmartDocConfig config_;
    protected SmartDocModel model_;
    protected SmartDocFormatConfig formatConfig_;

    // SmartDocGenerator
    public void init(SmartDocConfig config, SmartDocFormatConfig fconfig) {
	SmartDocContext context = SmartDocContext.getContext();
	monitor_ = context.getMonitor();
	config_ = config;
	formatConfig_ = fconfig;
    }

    public String getID() {
	return (formatConfig_.getID());
    }

    public String getName() {
	return (formatConfig_.getName());
    }

    // helper methods
    protected void _info(String message) {
	USmartDoc.info(message);
    }

    protected void _warning(String message) throws SmartDocWarningException {
	USmartDoc.warning(message);
    }

    protected void _error(String message) throws SmartDocErrorException {
	USmartDoc.error(message);
    }
}
