/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2002  ASAMI, Tomoharu (asami@XMLSmartDoc.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc;

import java.util.*;
import java.io.*;
import jp.gr.java_conf.jaba2.util.ExtensibleFactory;
import jp.gr.java_conf.jaba2.SmartDoc.normalizer.*;
import jp.gr.java_conf.jaba2.SmartDoc.control.*;

/**
 * NormalizerFactory
 *
 * @since   Mar. 31, 1999
 * @version Jan. 30, 2002
 * @author  ASAMI, Tomoharu (asami@XMLSmartDoc.org)
 */
public final class NormalizerFactory extends ExtensibleFactory {
    protected static NormalizerFactory factory__ = new NormalizerFactory();

    public static NormalizerFactory getFactory() {
	return (factory__);
    }

    protected NormalizerFactory() {
	try {
	    _setup(getClass().getResource(
		"/jp/gr/java_conf/jaba2/SmartDoc/Normalizer.xml"
	    ));
	} catch (IOException e) {
	    throw (new SmartDocErrorException(e));
	}
    }

    public INormalizer getNormalizer(String name) {
	if ("none".equals(name)) {
	    return (null);
	}
	INormalizer normalizer = (INormalizer)getTargetObject(name);
	if (normalizer == null) {
	    USmartDoc.warning("invalid normalizer: " + name);
	    return (null);
	}
	return (normalizer);
    }

    public INormalizer[] getNormalizers(String[] names) {
	List list = new ArrayList();
	for (int i = 0;i < names.length;i++) {
	    INormalizer normalizer = getNormalizer(names[i]);
	    if (normalizer != null) {
		list.add(normalizer);
	    }
	}
	INormalizer[] normalizers = new INormalizer[list.size()];
	return ((INormalizer[])list.toArray(normalizers));
    }

    public INormalizer[] getDefaultNormalizers(Content content) {
	if (content instanceof Paragraph) {
	    return (null);	// XXX
//	    return (new INormalizer[] {getNormalizer("naturallabel")});	// XXX
	} else if (content instanceof Sentence) {
	    return (null);
	} else if (content instanceof Table) {
	    return (null);
	} else if (content instanceof Colgroup) {
	    return (new INormalizer[] {getNormalizer("tag")});
	} else if (content instanceof Col) {
	    return (null);
	} else if (content instanceof Pre) {
	    return (null);
	} else if (content instanceof Title) {
	    return (new INormalizer[] {getNormalizer("naturallabel")});
	} else if (content instanceof Program) {
	    return (new INormalizer[] {getNormalizer("program")});
	} else if (content instanceof Console) {
	    return (new INormalizer[] {getNormalizer("console")});
	} else if (content instanceof Equation) {
	    return (new INormalizer[] {getNormalizer("tex")});
	} else if (content instanceof Native) {
	    return (null);
	} else if (content instanceof THead) {
	    return (new INormalizer[] {getNormalizer("csvthead")});
	} else if (content instanceof TFoot) {
	    return (new INormalizer[] {getNormalizer("csvthead")});
	} else if (content instanceof TBody) {
	    return (new INormalizer[] {getNormalizer("csvtbody")});
	} else if (content instanceof Tr) {
	    return (new INormalizer[] {getNormalizer("csvtr")});
	} else if (content instanceof Th) {
	    return (new INormalizer[] {getNormalizer("naturallabel")});
	} else if (content instanceof Td) {
	    return (new INormalizer[] {getNormalizer("naturallabel")});
	} else if (content instanceof Ref) {
	    return (new INormalizer[] {getNormalizer("href")});
	} else if (content instanceof Img) {
	    return (null);
//	    return (new INormalizer[] {getNormalizer("image")});
	} else if (content instanceof ImageFigure) {
	    return (null);
//	    return (new INormalizer[] {getNormalizer("image")});
	} else if (content instanceof Ul) {
	    return (new INormalizer[] {getNormalizer("tag")});
	} else if (content instanceof Ol) {
	    return (new INormalizer[] {getNormalizer("tag")});
	} else if (content instanceof Dl) {
	    return (new INormalizer[] {getNormalizer("tag")});
	} else if (content instanceof Li) {
	    return (new INormalizer[] {getNormalizer("naturallabel")});
	} else if (content instanceof Dt) {
	    return (new INormalizer[] {getNormalizer("naturallabel")});
	} else if (content instanceof Dd) {
	    return (new INormalizer[] {getNormalizer("naturallabel")});
	} else if (content instanceof Note) {
	    return (new INormalizer[] {getNormalizer("naturallabel")});
	} else if (content instanceof Define) {
	    return (null);
	} else if (content instanceof Summary) {
	    return (new INormalizer[] {getNormalizer("naturallabel")});
	} else {
	    switch (content.getEntityType()) {

	    case Content.ENTITY_BLOCK:
		return (new INormalizer[] {getNormalizer("natural")});
	    case Content.ENTITY_INLINE:
		return (null);
	    case Content.ENTITY_CONTAINER:
		return (null);
	    case Content.ENTITY_CONTROL:
		return (new INormalizer[] {getNormalizer("tag")});
	    default:
		throw (new InternalError());
	    }
	}
    }

/*
    public static INormalizer getNormalizer(String name) { // XXX : singleton
	if ("none".equals(name)) {
	    return (null);
	} if ("tag".equals(name)) {
	    return (new TagNormalizer());
	} else if ("natural".equals(name)) {
	    return (new NaturalNormalizer());
	} else if ("naturallabel".equals(name)) {
	    return (new NaturalLabelNormalizer());
	} else if ("csvthead".equals(name)) {
	    return (new CSVTHeadNormalizer());
	} else if ("csvtbody".equals(name)) {
	    return (new CSVTBodyNormalizer());
	} else if ("spacetbody".equals(name)) {
	    return (new SpaceTBodyNormalizer());
	} else if ("tabtbody".equals(name)) {
	    return (new TabTBodyNormalizer());
	} else if ("csvtr".equals(name)) {
	    return (new CSVTrNormalizer());
	} else if ("spacetr".equals(name)) {
	    return (new SpaceTrNormalizer());
	} else if ("tabtr".equals(name)) {
	    return (new TabTrNormalizer());
	} else if ("image".equals(name)) {
	    return (new ImageNormalizer());
	} else if ("href".equals(name)) {
	    return (new HrefNormalizer());
	} else {
	    throw (new IllegalArgumentException(name));
	}
    }

    public static INormalizer getDefaultNormalizer(Content content) {
	if (content instanceof Paragraph) {
	    return (null);
	} else if (content instanceof Sentence) {
	    return (null);
	} else if (content instanceof Table) {
	    return (null);
	} else if (content instanceof Pre) {
	    return (null);
	} else if (content instanceof Program) {
	    return (null);
	} else if (content instanceof Console) {
	    return (null);
	} else if (content instanceof Native) {
	    return (null);
	} else if (content instanceof THead) {
	    return (getNormalizer("csvthead"));
	} else if (content instanceof TFoot) {
	    return (getNormalizer("csvthead"));	// XXX
	} else if (content instanceof TBody) {
	    return (getNormalizer("csvtbody"));
	} else if (content instanceof Tr) {
	    return (getNormalizer("csvtr"));
	} else if (content instanceof Th) {
	    return (getNormalizer("naturallabel"));
	} else if (content instanceof Td) {
	    return (getNormalizer("naturallabel"));
	} else if (content instanceof Ref) {
	    return (getNormalizer("href"));
	} else if (content instanceof ImageFigure) {
	    return (getNormalizer("image"));
	} else if (content instanceof Ul) {
	    return (getNormalizer("tag"));
	} else if (content instanceof Ol) {
	    return (getNormalizer("tag"));
	} else if (content instanceof Dl) {
	    return (getNormalizer("tag"));
	} else if (content instanceof Li) {
	    return (getNormalizer("naturallabel"));
	} else {
	    switch (content.getEntityType()) {

	    case Content.ENTITY_BLOCK:
		return (getNormalizer("natural"));
	    case Content.ENTITY_INLINE:
		return (null);
	    case Content.ENTITY_CONTAINER:
		return (null);
	    case Content.ENTITY_CONTROL:
		return (getNormalizer("tag"));
	    default:
		throw (new InternalError());
	    }
	}
    }
*/
}
