/*
 * SmartTable
 *  Copyright (C) 1999,2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartTable;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.xml.UXML;
import jp.gr.java_conf.jaba2.xml.converter.TextConverter;

/**
 * DefaultColumnHandler
 *
 * @since   Aug.  5, 1999
 * @version Jan. 17, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class DefaultColumnHandler implements IColumnHandler {
    public void find(Element record, List list) {
	Element[] columns = UXML.listElements(record);
	for (int i = 0;i < columns.length;i++) {
	    String text = TextConverter.uNodes2String(columns[i]).trim();
	    USmartTable.addList(list, text);
	}
    }

    public String getColumnName() {
	return (null);
    }

    public int getColumnNumber() {
	return (-1);
    }

    public boolean match(int x) {
	return (true);
    }

/*
    public Element makeElement(Document doc) {
	return (doc.createElement("td"));
    }
*/

    public Element makeElement(Document doc, String text) {
	Element element = doc.createElement("td");
	element.appendChild(doc.createTextNode(text));
	return (element);
    }

    public Node[] makeData(Document doc, String text) {
	return (new Node[] {doc.createTextNode(text)});
    }
}
