package jp.gr.java_conf.jaba2.awt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.*;

/**
 * ActionButton
 *
 * @since   Apr. 12, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu
 */
public class ActionButton extends JButton {
    public ActionButton(Action action) {
	/*
	String name = (String)action.getValue(Action.NAME);
	Icon icon = (Icon)action.getValue(Action.SMALL_ICON);
	String tips = (String)action.getValue(Action.SHORT_DESCRIPTION);
	*/
	String name = (String)_getValue(action, Action.NAME);
	Icon icon = (Icon)_getValue(action, Action.SMALL_ICON);
	String tips = (String)_getValue(action, Action.SHORT_DESCRIPTION);
	if (name != null) {
	    setText(name);
	}
	if (icon != null) {
	    setIcon(icon);
	}
	if (tips != null) {
	    createToolTip().setTipText(tips);
	}
	addActionListener(action);
	action.addPropertyChangeListener(new PropertyChangeListener() {
	    public void propertyChange(PropertyChangeEvent evt) {
		if ("enabled".equals(evt.getPropertyName())) {
		    boolean enabled
			= ((Boolean)evt.getNewValue()).booleanValue();
		    setEnabled(enabled);
		}
	    }
	});
    }

    // test driver
    public static void main(String[] args) {
    }

    protected Object _getValue(Action action, String key) {
	Class clazz = action.getClass();
	try {
	    // JDK1.2 beta3
	    Class[] types = new Class[1];
	    types[0] = String.class;
	    Object[] args = new Object[1];
	    args[0] = key;
	    Method method = clazz.getMethod("getValue", types);
	    return (method.invoke(action, args));
	} catch (Exception e) {
	}
	try {
	    // JDK1.2 beta2
	    Class[] types = new Class[1];
	    types[0] = String.class;
	    Object[] args = new Object[1];
	    args[0] = key;
	    Method method = clazz.getMethod("getText", types);
	    if (!key.equals(Action.NAME)) {
		return (null);
	    }
	    return (method.invoke(action, args));
	} catch (Exception e) {
	    throw (new InternalError("invalid version"));
	}
    }
}
