/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1998  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.graph;

import java.util.*;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Component;
import java.awt.Container;
import jp.gr.java_conf.jaba2.awt.AbstractLayoutManager;

/**
 * GraphLayout
 *
 * @since   Nov. 13, 1998
 * @version Dec.  1, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class GraphLayout extends AbstractLayoutManager {
    public Dimension preferredLayoutSize(Container container) {
	return (new Dimension(500, 300));
    }

    public void layoutContainer(Container container) {
	Rectangle whole = container.getBounds();
	// XXX : sort
	Component[] comps = container.getComponents();
	for (int i = 0;i < comps.length;i++) {
	    Component comp = comps[i];
	    if (comp instanceof GraphLink) {
		comp.setBounds(new Rectangle(0, 0, whole.width, whole.height));
	    }
	}
    }
}
